package zio.aws.redshift.model
import scala.jdk.CollectionConverters._
sealed trait ReservedNodeOfferingType {
  def unwrap
      : software.amazon.awssdk.services.redshift.model.ReservedNodeOfferingType
}
object ReservedNodeOfferingType {
  def wrap(
      value: software.amazon.awssdk.services.redshift.model.ReservedNodeOfferingType
  ): zio.aws.redshift.model.ReservedNodeOfferingType = value match {
    case software.amazon.awssdk.services.redshift.model.ReservedNodeOfferingType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.redshift.model.ReservedNodeOfferingType.REGULAR =>
      val r = Regular
      r
    case software.amazon.awssdk.services.redshift.model.ReservedNodeOfferingType.UPGRADABLE =>
      val r = Upgradable
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.redshift.model.ReservedNodeOfferingType {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.ReservedNodeOfferingType =
      software.amazon.awssdk.services.redshift.model.ReservedNodeOfferingType.UNKNOWN_TO_SDK_VERSION
  }
  case object Regular extends zio.aws.redshift.model.ReservedNodeOfferingType {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.ReservedNodeOfferingType =
      software.amazon.awssdk.services.redshift.model.ReservedNodeOfferingType.REGULAR
  }
  case object Upgradable
      extends zio.aws.redshift.model.ReservedNodeOfferingType {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.ReservedNodeOfferingType =
      software.amazon.awssdk.services.redshift.model.ReservedNodeOfferingType.UPGRADABLE
  }
}
