package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeClusterSnapshotsResponse(
    marker: Optional[String] = Optional.Absent,
    snapshots: Optional[Iterable[zio.aws.redshift.model.Snapshot]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsResponse = {
    import DescribeClusterSnapshotsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        snapshots.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.snapshots)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeClusterSnapshotsResponse.ReadOnly =
    zio.aws.redshift.model.DescribeClusterSnapshotsResponse
      .wrap(buildAwsValue())
}
object DescribeClusterSnapshotsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeClusterSnapshotsResponse =
      zio.aws.redshift.model.DescribeClusterSnapshotsResponse(
        marker.map(value => value),
        snapshots.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def snapshots: Optional[List[zio.aws.redshift.model.Snapshot.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getSnapshots
        : ZIO[Any, AwsError, List[zio.aws.redshift.model.Snapshot.ReadOnly]] =
      AwsError.unwrapOptionField("snapshots", snapshots)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsResponse
  ) extends zio.aws.redshift.model.DescribeClusterSnapshotsResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val snapshots
        : Optional[List[zio.aws.redshift.model.Snapshot.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshots())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.Snapshot.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsResponse
  ): zio.aws.redshift.model.DescribeClusterSnapshotsResponse.ReadOnly =
    new Wrapper(impl)
}
