package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IPRange(
    status: Optional[String] = Optional.Absent,
    cidrip: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.redshift.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.IPRange = {
    import IPRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.IPRange
      .builder()
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(cidrip.map(value => value: java.lang.String))(_.cidrip)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.IPRange.ReadOnly =
    zio.aws.redshift.model.IPRange.wrap(buildAwsValue())
}
object IPRange {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.redshift.model.IPRange] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.IPRange =
      zio.aws.redshift.model.IPRange(
        status.map(value => value),
        cidrip.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def status: Optional[String]
    def cidrip: Optional[String]
    def tags: Optional[List[zio.aws.redshift.model.Tag.ReadOnly]]
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getCidrip: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidrip", cidrip)
    def getTags: ZIO[Any, AwsError, List[zio.aws.redshift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.IPRange
  ) extends zio.aws.redshift.model.IPRange.ReadOnly {
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val cidrip: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cidrip())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.redshift.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.IPRange
  ): zio.aws.redshift.model.IPRange.ReadOnly = new Wrapper(impl)
}
