package zio.aws.redshift.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.{IntegerOptional, TStamp}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeEventsRequest(
    sourceIdentifier: Optional[String] = Optional.Absent,
    sourceType: Optional[zio.aws.redshift.model.SourceType] = Optional.Absent,
    startTime: Optional[TStamp] = Optional.Absent,
    endTime: Optional[TStamp] = Optional.Absent,
    duration: Optional[IntegerOptional] = Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeEventsRequest = {
    import DescribeEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeEventsRequest
      .builder()
      .optionallyWith(sourceIdentifier.map(value => value: java.lang.String))(
        _.sourceIdentifier
      )
      .optionallyWith(sourceType.map(value => value.unwrap))(_.sourceType)
      .optionallyWith(startTime.map(value => TStamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => TStamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(duration.map(value => value: Integer))(_.duration)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.DescribeEventsRequest.ReadOnly =
    zio.aws.redshift.model.DescribeEventsRequest.wrap(buildAwsValue())
}
object DescribeEventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeEventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeEventsRequest =
      zio.aws.redshift.model.DescribeEventsRequest(
        sourceIdentifier.map(value => value),
        sourceType.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        duration.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def sourceIdentifier: Optional[String]
    def sourceType: Optional[zio.aws.redshift.model.SourceType]
    def startTime: Optional[TStamp]
    def endTime: Optional[TStamp]
    def duration: Optional[IntegerOptional]
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def getSourceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceIdentifier", sourceIdentifier)
    def getSourceType: ZIO[Any, AwsError, zio.aws.redshift.model.SourceType] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getStartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getDuration: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("duration", duration)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeEventsRequest
  ) extends zio.aws.redshift.model.DescribeEventsRequest.ReadOnly {
    override val sourceIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceIdentifier())
      .map(value => value: String)
    override val sourceType: Optional[zio.aws.redshift.model.SourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceType())
        .map(value => zio.aws.redshift.model.SourceType.wrap(value))
    override val startTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val endTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val duration: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.duration())
      .map(value => value: IntegerOptional)
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeEventsRequest
  ): zio.aws.redshift.model.DescribeEventsRequest.ReadOnly = new Wrapper(impl)
}
