package zio.aws.redshift.model
import scala.jdk.CollectionConverters._
sealed trait AquaConfigurationStatus {
  def unwrap
      : software.amazon.awssdk.services.redshift.model.AquaConfigurationStatus
}
object AquaConfigurationStatus {
  def wrap(
      value: software.amazon.awssdk.services.redshift.model.AquaConfigurationStatus
  ): zio.aws.redshift.model.AquaConfigurationStatus = value match {
    case software.amazon.awssdk.services.redshift.model.AquaConfigurationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.redshift.model.AquaConfigurationStatus.ENABLED =>
      val r = enabled
      r
    case software.amazon.awssdk.services.redshift.model.AquaConfigurationStatus.DISABLED =>
      val r = disabled
      r
    case software.amazon.awssdk.services.redshift.model.AquaConfigurationStatus.AUTO =>
      val r = auto
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.redshift.model.AquaConfigurationStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.AquaConfigurationStatus =
      software.amazon.awssdk.services.redshift.model.AquaConfigurationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object enabled extends zio.aws.redshift.model.AquaConfigurationStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.AquaConfigurationStatus =
      software.amazon.awssdk.services.redshift.model.AquaConfigurationStatus.ENABLED
  }
  case object disabled extends zio.aws.redshift.model.AquaConfigurationStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.AquaConfigurationStatus =
      software.amazon.awssdk.services.redshift.model.AquaConfigurationStatus.DISABLED
  }
  case object auto extends zio.aws.redshift.model.AquaConfigurationStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.AquaConfigurationStatus =
      software.amazon.awssdk.services.redshift.model.AquaConfigurationStatus.AUTO
  }
}
