package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.AuthenticationProfileNameString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateAuthenticationProfileRequest(
    authenticationProfileName: AuthenticationProfileNameString,
    authenticationProfileContent: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.CreateAuthenticationProfileRequest = {
    import CreateAuthenticationProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.CreateAuthenticationProfileRequest
      .builder()
      .authenticationProfileName(
        AuthenticationProfileNameString.unwrap(
          authenticationProfileName
        ): java.lang.String
      )
      .authenticationProfileContent(
        authenticationProfileContent: java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.CreateAuthenticationProfileRequest.ReadOnly =
    zio.aws.redshift.model.CreateAuthenticationProfileRequest
      .wrap(buildAwsValue())
}
object CreateAuthenticationProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.CreateAuthenticationProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.CreateAuthenticationProfileRequest =
      zio.aws.redshift.model.CreateAuthenticationProfileRequest(
        authenticationProfileName,
        authenticationProfileContent
      )
    def authenticationProfileName: AuthenticationProfileNameString
    def authenticationProfileContent: String
    def getAuthenticationProfileName
        : ZIO[Any, Nothing, AuthenticationProfileNameString] =
      ZIO.succeed(authenticationProfileName)
    def getAuthenticationProfileContent: ZIO[Any, Nothing, String] =
      ZIO.succeed(authenticationProfileContent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.CreateAuthenticationProfileRequest
  ) extends zio.aws.redshift.model.CreateAuthenticationProfileRequest.ReadOnly {
    override val authenticationProfileName: AuthenticationProfileNameString =
      zio.aws.redshift.model.primitives
        .AuthenticationProfileNameString(impl.authenticationProfileName())
    override val authenticationProfileContent: String =
      impl.authenticationProfileContent(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.CreateAuthenticationProfileRequest
  ): zio.aws.redshift.model.CreateAuthenticationProfileRequest.ReadOnly =
    new Wrapper(impl)
}
