package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RevokeSnapshotAccessRequest(
    snapshotIdentifier: Optional[String] = Optional.Absent,
    snapshotArn: Optional[String] = Optional.Absent,
    snapshotClusterIdentifier: Optional[String] = Optional.Absent,
    accountWithRestoreAccess: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.RevokeSnapshotAccessRequest = {
    import RevokeSnapshotAccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.RevokeSnapshotAccessRequest
      .builder()
      .optionallyWith(snapshotIdentifier.map(value => value: java.lang.String))(
        _.snapshotIdentifier
      )
      .optionallyWith(snapshotArn.map(value => value: java.lang.String))(
        _.snapshotArn
      )
      .optionallyWith(
        snapshotClusterIdentifier.map(value => value: java.lang.String)
      )(_.snapshotClusterIdentifier)
      .accountWithRestoreAccess(accountWithRestoreAccess: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.RevokeSnapshotAccessRequest.ReadOnly =
    zio.aws.redshift.model.RevokeSnapshotAccessRequest.wrap(buildAwsValue())
}
object RevokeSnapshotAccessRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.RevokeSnapshotAccessRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.RevokeSnapshotAccessRequest =
      zio.aws.redshift.model.RevokeSnapshotAccessRequest(
        snapshotIdentifier.map(value => value),
        snapshotArn.map(value => value),
        snapshotClusterIdentifier.map(value => value),
        accountWithRestoreAccess
      )
    def snapshotIdentifier: Optional[String]
    def snapshotArn: Optional[String]
    def snapshotClusterIdentifier: Optional[String]
    def accountWithRestoreAccess: String
    def getSnapshotIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotIdentifier", snapshotIdentifier)
    def getSnapshotArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotArn", snapshotArn)
    def getSnapshotClusterIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("snapshotClusterIdentifier", snapshotClusterIdentifier)
    def getAccountWithRestoreAccess: ZIO[Any, Nothing, String] =
      ZIO.succeed(accountWithRestoreAccess)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.RevokeSnapshotAccessRequest
  ) extends zio.aws.redshift.model.RevokeSnapshotAccessRequest.ReadOnly {
    override val snapshotIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotIdentifier())
      .map(value => value: String)
    override val snapshotArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotArn())
      .map(value => value: String)
    override val snapshotClusterIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotClusterIdentifier())
        .map(value => value: String)
    override val accountWithRestoreAccess: String =
      impl.accountWithRestoreAccess(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.RevokeSnapshotAccessRequest
  ): zio.aws.redshift.model.RevokeSnapshotAccessRequest.ReadOnly = new Wrapper(
    impl
  )
}
