package zio.aws.redshift.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeOrderableClusterOptionsRequest(
    clusterVersion: Optional[String] = Optional.Absent,
    nodeType: Optional[String] = Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsRequest = {
    import DescribeOrderableClusterOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsRequest
      .builder()
      .optionallyWith(clusterVersion.map(value => value: java.lang.String))(
        _.clusterVersion
      )
      .optionallyWith(nodeType.map(value => value: java.lang.String))(
        _.nodeType
      )
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeOrderableClusterOptionsRequest.ReadOnly =
    zio.aws.redshift.model.DescribeOrderableClusterOptionsRequest
      .wrap(buildAwsValue())
}
object DescribeOrderableClusterOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.DescribeOrderableClusterOptionsRequest =
      zio.aws.redshift.model.DescribeOrderableClusterOptionsRequest(
        clusterVersion.map(value => value),
        nodeType.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def clusterVersion: Optional[String]
    def nodeType: Optional[String]
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def getClusterVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterVersion", clusterVersion)
    def getNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeType", nodeType)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsRequest
  ) extends zio.aws.redshift.model.DescribeOrderableClusterOptionsRequest.ReadOnly {
    override val clusterVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterVersion())
      .map(value => value: String)
    override val nodeType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeType())
      .map(value => value: String)
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsRequest
  ): zio.aws.redshift.model.DescribeOrderableClusterOptionsRequest.ReadOnly =
    new Wrapper(impl)
}
