package zio.aws.redshift.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeTableRestoreStatusRequest(
    clusterIdentifier: Optional[String] = Optional.Absent,
    tableRestoreRequestId: Optional[String] = Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusRequest = {
    import DescribeTableRestoreStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusRequest
      .builder()
      .optionallyWith(clusterIdentifier.map(value => value: java.lang.String))(
        _.clusterIdentifier
      )
      .optionallyWith(
        tableRestoreRequestId.map(value => value: java.lang.String)
      )(_.tableRestoreRequestId)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeTableRestoreStatusRequest.ReadOnly =
    zio.aws.redshift.model.DescribeTableRestoreStatusRequest
      .wrap(buildAwsValue())
}
object DescribeTableRestoreStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeTableRestoreStatusRequest =
      zio.aws.redshift.model.DescribeTableRestoreStatusRequest(
        clusterIdentifier.map(value => value),
        tableRestoreRequestId.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def clusterIdentifier: Optional[String]
    def tableRestoreRequestId: Optional[String]
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def getClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getTableRestoreRequestId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tableRestoreRequestId", tableRestoreRequestId)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusRequest
  ) extends zio.aws.redshift.model.DescribeTableRestoreStatusRequest.ReadOnly {
    override val clusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterIdentifier())
      .map(value => value: String)
    override val tableRestoreRequestId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.tableRestoreRequestId())
      .map(value => value: String)
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusRequest
  ): zio.aws.redshift.model.DescribeTableRestoreStatusRequest.ReadOnly =
    new Wrapper(impl)
}
