package zio.aws.redshift.model
import scala.jdk.CollectionConverters._
sealed trait UsageLimitBreachAction {
  def unwrap
      : software.amazon.awssdk.services.redshift.model.UsageLimitBreachAction
}
object UsageLimitBreachAction {
  def wrap(
      value: software.amazon.awssdk.services.redshift.model.UsageLimitBreachAction
  ): zio.aws.redshift.model.UsageLimitBreachAction = value match {
    case software.amazon.awssdk.services.redshift.model.UsageLimitBreachAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.redshift.model.UsageLimitBreachAction.LOG =>
      val r = log
      r
    case software.amazon.awssdk.services.redshift.model.UsageLimitBreachAction.EMIT_METRIC =>
      val r = `emit-metric`
      r
    case software.amazon.awssdk.services.redshift.model.UsageLimitBreachAction.DISABLE =>
      val r = disable
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.redshift.model.UsageLimitBreachAction {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.UsageLimitBreachAction =
      software.amazon.awssdk.services.redshift.model.UsageLimitBreachAction.UNKNOWN_TO_SDK_VERSION
  }
  case object log extends zio.aws.redshift.model.UsageLimitBreachAction {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.UsageLimitBreachAction =
      software.amazon.awssdk.services.redshift.model.UsageLimitBreachAction.LOG
  }
  case object `emit-metric`
      extends zio.aws.redshift.model.UsageLimitBreachAction {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.UsageLimitBreachAction =
      software.amazon.awssdk.services.redshift.model.UsageLimitBreachAction.EMIT_METRIC
  }
  case object disable extends zio.aws.redshift.model.UsageLimitBreachAction {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.UsageLimitBreachAction =
      software.amazon.awssdk.services.redshift.model.UsageLimitBreachAction.DISABLE
  }
}
