package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeSnapshotSchedulesResponse(
    snapshotSchedules: Optional[
      Iterable[zio.aws.redshift.model.SnapshotSchedule]
    ] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesResponse = {
    import DescribeSnapshotSchedulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesResponse
      .builder()
      .optionallyWith(
        snapshotSchedules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.snapshotSchedules)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeSnapshotSchedulesResponse.ReadOnly =
    zio.aws.redshift.model.DescribeSnapshotSchedulesResponse
      .wrap(buildAwsValue())
}
object DescribeSnapshotSchedulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeSnapshotSchedulesResponse =
      zio.aws.redshift.model.DescribeSnapshotSchedulesResponse(
        snapshotSchedules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def snapshotSchedules
        : Optional[List[zio.aws.redshift.model.SnapshotSchedule.ReadOnly]]
    def marker: Optional[String]
    def getSnapshotSchedules: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.SnapshotSchedule.ReadOnly
    ]] = AwsError.unwrapOptionField("snapshotSchedules", snapshotSchedules)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesResponse
  ) extends zio.aws.redshift.model.DescribeSnapshotSchedulesResponse.ReadOnly {
    override val snapshotSchedules
        : Optional[List[zio.aws.redshift.model.SnapshotSchedule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotSchedules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.SnapshotSchedule.wrap(item)
          }.toList
        )
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesResponse
  ): zio.aws.redshift.model.DescribeSnapshotSchedulesResponse.ReadOnly =
    new Wrapper(impl)
}
