package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NetworkInterface(
    networkInterfaceId: Optional[String] = Optional.Absent,
    subnetId: Optional[String] = Optional.Absent,
    privateIpAddress: Optional[String] = Optional.Absent,
    availabilityZone: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.NetworkInterface = {
    import NetworkInterface.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.NetworkInterface
      .builder()
      .optionallyWith(networkInterfaceId.map(value => value: java.lang.String))(
        _.networkInterfaceId
      )
      .optionallyWith(subnetId.map(value => value: java.lang.String))(
        _.subnetId
      )
      .optionallyWith(privateIpAddress.map(value => value: java.lang.String))(
        _.privateIpAddress
      )
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.NetworkInterface.ReadOnly =
    zio.aws.redshift.model.NetworkInterface.wrap(buildAwsValue())
}
object NetworkInterface {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.NetworkInterface
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.NetworkInterface =
      zio.aws.redshift.model.NetworkInterface(
        networkInterfaceId.map(value => value),
        subnetId.map(value => value),
        privateIpAddress.map(value => value),
        availabilityZone.map(value => value)
      )
    def networkInterfaceId: Optional[String]
    def subnetId: Optional[String]
    def privateIpAddress: Optional[String]
    def availabilityZone: Optional[String]
    def getNetworkInterfaceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getSubnetId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getPrivateIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateIpAddress", privateIpAddress)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.NetworkInterface
  ) extends zio.aws.redshift.model.NetworkInterface.ReadOnly {
    override val networkInterfaceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInterfaceId())
      .map(value => value: String)
    override val subnetId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => value: String)
    override val privateIpAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.privateIpAddress())
      .map(value => value: String)
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.NetworkInterface
  ): zio.aws.redshift.model.NetworkInterface.ReadOnly = new Wrapper(impl)
}
