package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.BooleanOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DisassociateDataShareConsumerRequest(
    dataShareArn: String,
    disassociateEntireAccount: Optional[BooleanOptional] = Optional.Absent,
    consumerArn: Optional[String] = Optional.Absent,
    consumerRegion: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DisassociateDataShareConsumerRequest = {
    import DisassociateDataShareConsumerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DisassociateDataShareConsumerRequest
      .builder()
      .dataShareArn(dataShareArn: java.lang.String)
      .optionallyWith(
        disassociateEntireAccount.map(value => value: java.lang.Boolean)
      )(_.disassociateEntireAccount)
      .optionallyWith(consumerArn.map(value => value: java.lang.String))(
        _.consumerArn
      )
      .optionallyWith(consumerRegion.map(value => value: java.lang.String))(
        _.consumerRegion
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DisassociateDataShareConsumerRequest.ReadOnly =
    zio.aws.redshift.model.DisassociateDataShareConsumerRequest
      .wrap(buildAwsValue())
}
object DisassociateDataShareConsumerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DisassociateDataShareConsumerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.DisassociateDataShareConsumerRequest =
      zio.aws.redshift.model.DisassociateDataShareConsumerRequest(
        dataShareArn,
        disassociateEntireAccount.map(value => value),
        consumerArn.map(value => value),
        consumerRegion.map(value => value)
      )
    def dataShareArn: String
    def disassociateEntireAccount: Optional[BooleanOptional]
    def consumerArn: Optional[String]
    def consumerRegion: Optional[String]
    def getDataShareArn: ZIO[Any, Nothing, String] = ZIO.succeed(dataShareArn)
    def getDisassociateEntireAccount: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "disassociateEntireAccount",
        disassociateEntireAccount
      )
    def getConsumerArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("consumerArn", consumerArn)
    def getConsumerRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("consumerRegion", consumerRegion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DisassociateDataShareConsumerRequest
  ) extends zio.aws.redshift.model.DisassociateDataShareConsumerRequest.ReadOnly {
    override val dataShareArn: String = impl.dataShareArn(): String
    override val disassociateEntireAccount: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disassociateEntireAccount())
        .map(value => value: BooleanOptional)
    override val consumerArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.consumerArn())
      .map(value => value: String)
    override val consumerRegion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.consumerRegion())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DisassociateDataShareConsumerRequest
  ): zio.aws.redshift.model.DisassociateDataShareConsumerRequest.ReadOnly =
    new Wrapper(impl)
}
