package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.{
  PartnerIntegrationPartnerName,
  PartnerIntegrationDatabaseName,
  PartnerIntegrationClusterIdentifier,
  PartnerIntegrationAccountId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribePartnersRequest(
    accountId: PartnerIntegrationAccountId,
    clusterIdentifier: PartnerIntegrationClusterIdentifier,
    databaseName: Optional[PartnerIntegrationDatabaseName] = Optional.Absent,
    partnerName: Optional[PartnerIntegrationPartnerName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribePartnersRequest = {
    import DescribePartnersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribePartnersRequest
      .builder()
      .accountId(
        PartnerIntegrationAccountId.unwrap(accountId): java.lang.String
      )
      .clusterIdentifier(
        PartnerIntegrationClusterIdentifier.unwrap(
          clusterIdentifier
        ): java.lang.String
      )
      .optionallyWith(
        databaseName.map(value =>
          PartnerIntegrationDatabaseName.unwrap(value): java.lang.String
        )
      )(_.databaseName)
      .optionallyWith(
        partnerName.map(value =>
          PartnerIntegrationPartnerName.unwrap(value): java.lang.String
        )
      )(_.partnerName)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.DescribePartnersRequest.ReadOnly =
    zio.aws.redshift.model.DescribePartnersRequest.wrap(buildAwsValue())
}
object DescribePartnersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribePartnersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribePartnersRequest =
      zio.aws.redshift.model.DescribePartnersRequest(
        accountId,
        clusterIdentifier,
        databaseName.map(value => value),
        partnerName.map(value => value)
      )
    def accountId: PartnerIntegrationAccountId
    def clusterIdentifier: PartnerIntegrationClusterIdentifier
    def databaseName: Optional[PartnerIntegrationDatabaseName]
    def partnerName: Optional[PartnerIntegrationPartnerName]
    def getAccountId: ZIO[Any, Nothing, PartnerIntegrationAccountId] =
      ZIO.succeed(accountId)
    def getClusterIdentifier
        : ZIO[Any, Nothing, PartnerIntegrationClusterIdentifier] =
      ZIO.succeed(clusterIdentifier)
    def getDatabaseName: ZIO[Any, AwsError, PartnerIntegrationDatabaseName] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getPartnerName: ZIO[Any, AwsError, PartnerIntegrationPartnerName] =
      AwsError.unwrapOptionField("partnerName", partnerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribePartnersRequest
  ) extends zio.aws.redshift.model.DescribePartnersRequest.ReadOnly {
    override val accountId: PartnerIntegrationAccountId =
      zio.aws.redshift.model.primitives
        .PartnerIntegrationAccountId(impl.accountId())
    override val clusterIdentifier: PartnerIntegrationClusterIdentifier =
      zio.aws.redshift.model.primitives
        .PartnerIntegrationClusterIdentifier(impl.clusterIdentifier())
    override val databaseName: Optional[PartnerIntegrationDatabaseName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.databaseName())
        .map(value =>
          zio.aws.redshift.model.primitives
            .PartnerIntegrationDatabaseName(value)
        )
    override val partnerName: Optional[PartnerIntegrationPartnerName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.partnerName())
        .map(value =>
          zio.aws.redshift.model.primitives.PartnerIntegrationPartnerName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribePartnersRequest
  ): zio.aws.redshift.model.DescribePartnersRequest.ReadOnly = new Wrapper(impl)
}
