package zio.aws.redshift.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.{
  LongOptional,
  DoubleOptional,
  IntegerOptional
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeResizeResponse(
    targetNodeType: Optional[String] = Optional.Absent,
    targetNumberOfNodes: Optional[IntegerOptional] = Optional.Absent,
    targetClusterType: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    importTablesCompleted: Optional[Iterable[String]] = Optional.Absent,
    importTablesInProgress: Optional[Iterable[String]] = Optional.Absent,
    importTablesNotStarted: Optional[Iterable[String]] = Optional.Absent,
    avgResizeRateInMegaBytesPerSecond: Optional[DoubleOptional] =
      Optional.Absent,
    totalResizeDataInMegaBytes: Optional[LongOptional] = Optional.Absent,
    progressInMegaBytes: Optional[LongOptional] = Optional.Absent,
    elapsedTimeInSeconds: Optional[LongOptional] = Optional.Absent,
    estimatedTimeToCompletionInSeconds: Optional[LongOptional] =
      Optional.Absent,
    resizeType: Optional[String] = Optional.Absent,
    message: Optional[String] = Optional.Absent,
    targetEncryptionType: Optional[String] = Optional.Absent,
    dataTransferProgressPercent: Optional[DoubleOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeResizeResponse = {
    import DescribeResizeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeResizeResponse
      .builder()
      .optionallyWith(targetNodeType.map(value => value: java.lang.String))(
        _.targetNodeType
      )
      .optionallyWith(targetNumberOfNodes.map(value => value: Integer))(
        _.targetNumberOfNodes
      )
      .optionallyWith(targetClusterType.map(value => value: java.lang.String))(
        _.targetClusterType
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        importTablesCompleted.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.importTablesCompleted)
      .optionallyWith(
        importTablesInProgress.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.importTablesInProgress)
      .optionallyWith(
        importTablesNotStarted.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.importTablesNotStarted)
      .optionallyWith(
        avgResizeRateInMegaBytesPerSecond.map(value => value: java.lang.Double)
      )(_.avgResizeRateInMegaBytesPerSecond)
      .optionallyWith(
        totalResizeDataInMegaBytes.map(value => value: java.lang.Long)
      )(_.totalResizeDataInMegaBytes)
      .optionallyWith(progressInMegaBytes.map(value => value: java.lang.Long))(
        _.progressInMegaBytes
      )
      .optionallyWith(elapsedTimeInSeconds.map(value => value: java.lang.Long))(
        _.elapsedTimeInSeconds
      )
      .optionallyWith(
        estimatedTimeToCompletionInSeconds.map(value => value: java.lang.Long)
      )(_.estimatedTimeToCompletionInSeconds)
      .optionallyWith(resizeType.map(value => value: java.lang.String))(
        _.resizeType
      )
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(
        targetEncryptionType.map(value => value: java.lang.String)
      )(_.targetEncryptionType)
      .optionallyWith(
        dataTransferProgressPercent.map(value => value: java.lang.Double)
      )(_.dataTransferProgressPercent)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.DescribeResizeResponse.ReadOnly =
    zio.aws.redshift.model.DescribeResizeResponse.wrap(buildAwsValue())
}
object DescribeResizeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeResizeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeResizeResponse =
      zio.aws.redshift.model.DescribeResizeResponse(
        targetNodeType.map(value => value),
        targetNumberOfNodes.map(value => value),
        targetClusterType.map(value => value),
        status.map(value => value),
        importTablesCompleted.map(value => value),
        importTablesInProgress.map(value => value),
        importTablesNotStarted.map(value => value),
        avgResizeRateInMegaBytesPerSecond.map(value => value),
        totalResizeDataInMegaBytes.map(value => value),
        progressInMegaBytes.map(value => value),
        elapsedTimeInSeconds.map(value => value),
        estimatedTimeToCompletionInSeconds.map(value => value),
        resizeType.map(value => value),
        message.map(value => value),
        targetEncryptionType.map(value => value),
        dataTransferProgressPercent.map(value => value)
      )
    def targetNodeType: Optional[String]
    def targetNumberOfNodes: Optional[IntegerOptional]
    def targetClusterType: Optional[String]
    def status: Optional[String]
    def importTablesCompleted: Optional[List[String]]
    def importTablesInProgress: Optional[List[String]]
    def importTablesNotStarted: Optional[List[String]]
    def avgResizeRateInMegaBytesPerSecond: Optional[DoubleOptional]
    def totalResizeDataInMegaBytes: Optional[LongOptional]
    def progressInMegaBytes: Optional[LongOptional]
    def elapsedTimeInSeconds: Optional[LongOptional]
    def estimatedTimeToCompletionInSeconds: Optional[LongOptional]
    def resizeType: Optional[String]
    def message: Optional[String]
    def targetEncryptionType: Optional[String]
    def dataTransferProgressPercent: Optional[DoubleOptional]
    def getTargetNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetNodeType", targetNodeType)
    def getTargetNumberOfNodes: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("targetNumberOfNodes", targetNumberOfNodes)
    def getTargetClusterType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetClusterType", targetClusterType)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getImportTablesCompleted: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("importTablesCompleted", importTablesCompleted)
    def getImportTablesInProgress: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("importTablesInProgress", importTablesInProgress)
    def getImportTablesNotStarted: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("importTablesNotStarted", importTablesNotStarted)
    def getAvgResizeRateInMegaBytesPerSecond
        : ZIO[Any, AwsError, DoubleOptional] = AwsError.unwrapOptionField(
      "avgResizeRateInMegaBytesPerSecond",
      avgResizeRateInMegaBytesPerSecond
    )
    def getTotalResizeDataInMegaBytes: ZIO[Any, AwsError, LongOptional] =
      AwsError.unwrapOptionField(
        "totalResizeDataInMegaBytes",
        totalResizeDataInMegaBytes
      )
    def getProgressInMegaBytes: ZIO[Any, AwsError, LongOptional] =
      AwsError.unwrapOptionField("progressInMegaBytes", progressInMegaBytes)
    def getElapsedTimeInSeconds: ZIO[Any, AwsError, LongOptional] =
      AwsError.unwrapOptionField("elapsedTimeInSeconds", elapsedTimeInSeconds)
    def getEstimatedTimeToCompletionInSeconds
        : ZIO[Any, AwsError, LongOptional] = AwsError.unwrapOptionField(
      "estimatedTimeToCompletionInSeconds",
      estimatedTimeToCompletionInSeconds
    )
    def getResizeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resizeType", resizeType)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
    def getTargetEncryptionType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetEncryptionType", targetEncryptionType)
    def getDataTransferProgressPercent: ZIO[Any, AwsError, DoubleOptional] =
      AwsError.unwrapOptionField(
        "dataTransferProgressPercent",
        dataTransferProgressPercent
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeResizeResponse
  ) extends zio.aws.redshift.model.DescribeResizeResponse.ReadOnly {
    override val targetNodeType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.targetNodeType())
      .map(value => value: String)
    override val targetNumberOfNodes: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetNumberOfNodes())
        .map(value => value: IntegerOptional)
    override val targetClusterType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.targetClusterType())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val importTablesCompleted: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importTablesCompleted())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val importTablesInProgress: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importTablesInProgress())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val importTablesNotStarted: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importTablesNotStarted())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val avgResizeRateInMegaBytesPerSecond: Optional[DoubleOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.avgResizeRateInMegaBytesPerSecond())
        .map(value => value: DoubleOptional)
    override val totalResizeDataInMegaBytes: Optional[LongOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalResizeDataInMegaBytes())
        .map(value => value: LongOptional)
    override val progressInMegaBytes: Optional[LongOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.progressInMegaBytes())
        .map(value => value: LongOptional)
    override val elapsedTimeInSeconds: Optional[LongOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.elapsedTimeInSeconds())
        .map(value => value: LongOptional)
    override val estimatedTimeToCompletionInSeconds: Optional[LongOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.estimatedTimeToCompletionInSeconds())
        .map(value => value: LongOptional)
    override val resizeType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resizeType())
      .map(value => value: String)
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
    override val targetEncryptionType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.targetEncryptionType())
      .map(value => value: String)
    override val dataTransferProgressPercent: Optional[DoubleOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataTransferProgressPercent())
        .map(value => value: DoubleOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeResizeResponse
  ): zio.aws.redshift.model.DescribeResizeResponse.ReadOnly = new Wrapper(impl)
}
