package zio.aws.redshift.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeUsageLimitsRequest(
    usageLimitId: Optional[String] = Optional.Absent,
    clusterIdentifier: Optional[String] = Optional.Absent,
    featureType: Optional[zio.aws.redshift.model.UsageLimitFeatureType] =
      Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent,
    tagKeys: Optional[Iterable[String]] = Optional.Absent,
    tagValues: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeUsageLimitsRequest = {
    import DescribeUsageLimitsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeUsageLimitsRequest
      .builder()
      .optionallyWith(usageLimitId.map(value => value: java.lang.String))(
        _.usageLimitId
      )
      .optionallyWith(clusterIdentifier.map(value => value: java.lang.String))(
        _.clusterIdentifier
      )
      .optionallyWith(featureType.map(value => value.unwrap))(_.featureType)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        tagKeys.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.tagKeys)
      .optionallyWith(
        tagValues.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.tagValues)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.DescribeUsageLimitsRequest.ReadOnly =
    zio.aws.redshift.model.DescribeUsageLimitsRequest.wrap(buildAwsValue())
}
object DescribeUsageLimitsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeUsageLimitsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeUsageLimitsRequest =
      zio.aws.redshift.model.DescribeUsageLimitsRequest(
        usageLimitId.map(value => value),
        clusterIdentifier.map(value => value),
        featureType.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value),
        tagKeys.map(value => value),
        tagValues.map(value => value)
      )
    def usageLimitId: Optional[String]
    def clusterIdentifier: Optional[String]
    def featureType: Optional[zio.aws.redshift.model.UsageLimitFeatureType]
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def tagKeys: Optional[List[String]]
    def tagValues: Optional[List[String]]
    def getUsageLimitId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("usageLimitId", usageLimitId)
    def getClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getFeatureType
        : ZIO[Any, AwsError, zio.aws.redshift.model.UsageLimitFeatureType] =
      AwsError.unwrapOptionField("featureType", featureType)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getTagKeys: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("tagKeys", tagKeys)
    def getTagValues: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("tagValues", tagValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeUsageLimitsRequest
  ) extends zio.aws.redshift.model.DescribeUsageLimitsRequest.ReadOnly {
    override val usageLimitId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.usageLimitId())
      .map(value => value: String)
    override val clusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterIdentifier())
      .map(value => value: String)
    override val featureType
        : Optional[zio.aws.redshift.model.UsageLimitFeatureType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featureType())
        .map(value => zio.aws.redshift.model.UsageLimitFeatureType.wrap(value))
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val tagKeys: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tagKeys())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val tagValues: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tagValues())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeUsageLimitsRequest
  ): zio.aws.redshift.model.DescribeUsageLimitsRequest.ReadOnly = new Wrapper(
    impl
  )
}
