package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeSnapshotCopyGrantsResponse(
    marker: Optional[String] = Optional.Absent,
    snapshotCopyGrants: Optional[
      Iterable[zio.aws.redshift.model.SnapshotCopyGrant]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsResponse = {
    import DescribeSnapshotCopyGrantsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        snapshotCopyGrants.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.snapshotCopyGrants)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeSnapshotCopyGrantsResponse.ReadOnly =
    zio.aws.redshift.model.DescribeSnapshotCopyGrantsResponse
      .wrap(buildAwsValue())
}
object DescribeSnapshotCopyGrantsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeSnapshotCopyGrantsResponse =
      zio.aws.redshift.model.DescribeSnapshotCopyGrantsResponse(
        marker.map(value => value),
        snapshotCopyGrants.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def snapshotCopyGrants
        : Optional[List[zio.aws.redshift.model.SnapshotCopyGrant.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getSnapshotCopyGrants: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.SnapshotCopyGrant.ReadOnly
    ]] = AwsError.unwrapOptionField("snapshotCopyGrants", snapshotCopyGrants)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsResponse
  ) extends zio.aws.redshift.model.DescribeSnapshotCopyGrantsResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val snapshotCopyGrants
        : Optional[List[zio.aws.redshift.model.SnapshotCopyGrant.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotCopyGrants())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.SnapshotCopyGrant.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsResponse
  ): zio.aws.redshift.model.DescribeSnapshotCopyGrantsResponse.ReadOnly =
    new Wrapper(impl)
}
