package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ModifyClusterParameterGroupRequest(
    parameterGroupName: String,
    parameters: Iterable[zio.aws.redshift.model.Parameter]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ModifyClusterParameterGroupRequest = {
    import ModifyClusterParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ModifyClusterParameterGroupRequest
      .builder()
      .parameterGroupName(parameterGroupName: java.lang.String)
      .parameters(parameters.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.ModifyClusterParameterGroupRequest.ReadOnly =
    zio.aws.redshift.model.ModifyClusterParameterGroupRequest
      .wrap(buildAwsValue())
}
object ModifyClusterParameterGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ModifyClusterParameterGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ModifyClusterParameterGroupRequest =
      zio.aws.redshift.model.ModifyClusterParameterGroupRequest(
        parameterGroupName,
        parameters.map { item =>
          item.asEditable
        }
      )
    def parameterGroupName: String
    def parameters: List[zio.aws.redshift.model.Parameter.ReadOnly]
    def getParameterGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(parameterGroupName)
    def getParameters
        : ZIO[Any, Nothing, List[zio.aws.redshift.model.Parameter.ReadOnly]] =
      ZIO.succeed(parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ModifyClusterParameterGroupRequest
  ) extends zio.aws.redshift.model.ModifyClusterParameterGroupRequest.ReadOnly {
    override val parameterGroupName: String = impl.parameterGroupName(): String
    override val parameters: List[zio.aws.redshift.model.Parameter.ReadOnly] =
      impl
        .parameters()
        .asScala
        .map { item =>
          zio.aws.redshift.model.Parameter.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ModifyClusterParameterGroupRequest
  ): zio.aws.redshift.model.ModifyClusterParameterGroupRequest.ReadOnly =
    new Wrapper(impl)
}
