package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EC2SecurityGroup(
    status: Optional[String] = Optional.Absent,
    ec2SecurityGroupName: Optional[String] = Optional.Absent,
    ec2SecurityGroupOwnerId: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.redshift.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.EC2SecurityGroup = {
    import EC2SecurityGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.EC2SecurityGroup
      .builder()
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        ec2SecurityGroupName.map(value => value: java.lang.String)
      )(_.ec2SecurityGroupName)
      .optionallyWith(
        ec2SecurityGroupOwnerId.map(value => value: java.lang.String)
      )(_.ec2SecurityGroupOwnerId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.EC2SecurityGroup.ReadOnly =
    zio.aws.redshift.model.EC2SecurityGroup.wrap(buildAwsValue())
}
object EC2SecurityGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.EC2SecurityGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.EC2SecurityGroup =
      zio.aws.redshift.model.EC2SecurityGroup(
        status.map(value => value),
        ec2SecurityGroupName.map(value => value),
        ec2SecurityGroupOwnerId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def status: Optional[String]
    def ec2SecurityGroupName: Optional[String]
    def ec2SecurityGroupOwnerId: Optional[String]
    def tags: Optional[List[zio.aws.redshift.model.Tag.ReadOnly]]
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getEc2SecurityGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ec2SecurityGroupName", ec2SecurityGroupName)
    def getEc2SecurityGroupOwnerId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("ec2SecurityGroupOwnerId", ec2SecurityGroupOwnerId)
    def getTags: ZIO[Any, AwsError, List[zio.aws.redshift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.EC2SecurityGroup
  ) extends zio.aws.redshift.model.EC2SecurityGroup.ReadOnly {
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val ec2SecurityGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ec2SecurityGroupName())
      .map(value => value: String)
    override val ec2SecurityGroupOwnerId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ec2SecurityGroupOwnerId())
        .map(value => value: String)
    override val tags: Optional[List[zio.aws.redshift.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.EC2SecurityGroup
  ): zio.aws.redshift.model.EC2SecurityGroup.ReadOnly = new Wrapper(impl)
}
