package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteClusterSnapshotMessage(
    snapshotIdentifier: String,
    snapshotClusterIdentifier: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DeleteClusterSnapshotMessage = {
    import DeleteClusterSnapshotMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DeleteClusterSnapshotMessage
      .builder()
      .snapshotIdentifier(snapshotIdentifier: java.lang.String)
      .optionallyWith(
        snapshotClusterIdentifier.map(value => value: java.lang.String)
      )(_.snapshotClusterIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.DeleteClusterSnapshotMessage.ReadOnly =
    zio.aws.redshift.model.DeleteClusterSnapshotMessage.wrap(buildAwsValue())
}
object DeleteClusterSnapshotMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DeleteClusterSnapshotMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DeleteClusterSnapshotMessage =
      zio.aws.redshift.model.DeleteClusterSnapshotMessage(
        snapshotIdentifier,
        snapshotClusterIdentifier.map(value => value)
      )
    def snapshotIdentifier: String
    def snapshotClusterIdentifier: Optional[String]
    def getSnapshotIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(snapshotIdentifier)
    def getSnapshotClusterIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("snapshotClusterIdentifier", snapshotClusterIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DeleteClusterSnapshotMessage
  ) extends zio.aws.redshift.model.DeleteClusterSnapshotMessage.ReadOnly {
    override val snapshotIdentifier: String = impl.snapshotIdentifier(): String
    override val snapshotClusterIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotClusterIdentifier())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DeleteClusterSnapshotMessage
  ): zio.aws.redshift.model.DeleteClusterSnapshotMessage.ReadOnly = new Wrapper(
    impl
  )
}
