package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AccountWithRestoreAccess(
    accountId: Optional[String] = Optional.Absent,
    accountAlias: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.AccountWithRestoreAccess = {
    import AccountWithRestoreAccess.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.AccountWithRestoreAccess
      .builder()
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .optionallyWith(accountAlias.map(value => value: java.lang.String))(
        _.accountAlias
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.AccountWithRestoreAccess.ReadOnly =
    zio.aws.redshift.model.AccountWithRestoreAccess.wrap(buildAwsValue())
}
object AccountWithRestoreAccess {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.AccountWithRestoreAccess
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.AccountWithRestoreAccess =
      zio.aws.redshift.model.AccountWithRestoreAccess(
        accountId.map(value => value),
        accountAlias.map(value => value)
      )
    def accountId: Optional[String]
    def accountAlias: Optional[String]
    def getAccountId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getAccountAlias: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("accountAlias", accountAlias)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.AccountWithRestoreAccess
  ) extends zio.aws.redshift.model.AccountWithRestoreAccess.ReadOnly {
    override val accountId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => value: String)
    override val accountAlias: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.accountAlias())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.AccountWithRestoreAccess
  ): zio.aws.redshift.model.AccountWithRestoreAccess.ReadOnly = new Wrapper(
    impl
  )
}
