package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RejectDataShareResponse(
    dataShareArn: Optional[String] = Optional.Absent,
    producerArn: Optional[String] = Optional.Absent,
    allowPubliclyAccessibleConsumers: Optional[Boolean] = Optional.Absent,
    dataShareAssociations: Optional[
      Iterable[zio.aws.redshift.model.DataShareAssociation]
    ] = Optional.Absent,
    managedBy: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.RejectDataShareResponse = {
    import RejectDataShareResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.RejectDataShareResponse
      .builder()
      .optionallyWith(dataShareArn.map(value => value: java.lang.String))(
        _.dataShareArn
      )
      .optionallyWith(producerArn.map(value => value: java.lang.String))(
        _.producerArn
      )
      .optionallyWith(
        allowPubliclyAccessibleConsumers.map(value => value: java.lang.Boolean)
      )(_.allowPubliclyAccessibleConsumers)
      .optionallyWith(
        dataShareAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataShareAssociations)
      .optionallyWith(managedBy.map(value => value: java.lang.String))(
        _.managedBy
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.RejectDataShareResponse.ReadOnly =
    zio.aws.redshift.model.RejectDataShareResponse.wrap(buildAwsValue())
}
object RejectDataShareResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.RejectDataShareResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.RejectDataShareResponse =
      zio.aws.redshift.model.RejectDataShareResponse(
        dataShareArn.map(value => value),
        producerArn.map(value => value),
        allowPubliclyAccessibleConsumers.map(value => value),
        dataShareAssociations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        managedBy.map(value => value)
      )
    def dataShareArn: Optional[String]
    def producerArn: Optional[String]
    def allowPubliclyAccessibleConsumers: Optional[Boolean]
    def dataShareAssociations
        : Optional[List[zio.aws.redshift.model.DataShareAssociation.ReadOnly]]
    def managedBy: Optional[String]
    def getDataShareArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataShareArn", dataShareArn)
    def getProducerArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("producerArn", producerArn)
    def getAllowPubliclyAccessibleConsumers: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "allowPubliclyAccessibleConsumers",
        allowPubliclyAccessibleConsumers
      )
    def getDataShareAssociations: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.DataShareAssociation.ReadOnly
    ]] =
      AwsError.unwrapOptionField("dataShareAssociations", dataShareAssociations)
    def getManagedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("managedBy", managedBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.RejectDataShareResponse
  ) extends zio.aws.redshift.model.RejectDataShareResponse.ReadOnly {
    override val dataShareArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dataShareArn())
      .map(value => value: String)
    override val producerArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.producerArn())
      .map(value => value: String)
    override val allowPubliclyAccessibleConsumers: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowPubliclyAccessibleConsumers())
        .map(value => value: Boolean)
    override val dataShareAssociations
        : Optional[List[zio.aws.redshift.model.DataShareAssociation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataShareAssociations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.DataShareAssociation.wrap(item)
          }.toList
        )
    override val managedBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.managedBy())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.RejectDataShareResponse
  ): zio.aws.redshift.model.RejectDataShareResponse.ReadOnly = new Wrapper(impl)
}
