package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.AuthenticationProfileNameString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteAuthenticationProfileRequest(
    authenticationProfileName: AuthenticationProfileNameString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DeleteAuthenticationProfileRequest = {
    import DeleteAuthenticationProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DeleteAuthenticationProfileRequest
      .builder()
      .authenticationProfileName(
        AuthenticationProfileNameString.unwrap(
          authenticationProfileName
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DeleteAuthenticationProfileRequest.ReadOnly =
    zio.aws.redshift.model.DeleteAuthenticationProfileRequest
      .wrap(buildAwsValue())
}
object DeleteAuthenticationProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DeleteAuthenticationProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DeleteAuthenticationProfileRequest =
      zio.aws.redshift.model
        .DeleteAuthenticationProfileRequest(authenticationProfileName)
    def authenticationProfileName: AuthenticationProfileNameString
    def getAuthenticationProfileName
        : ZIO[Any, Nothing, AuthenticationProfileNameString] =
      ZIO.succeed(authenticationProfileName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DeleteAuthenticationProfileRequest
  ) extends zio.aws.redshift.model.DeleteAuthenticationProfileRequest.ReadOnly {
    override val authenticationProfileName: AuthenticationProfileNameString =
      zio.aws.redshift.model.primitives
        .AuthenticationProfileNameString(impl.authenticationProfileName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DeleteAuthenticationProfileRequest
  ): zio.aws.redshift.model.DeleteAuthenticationProfileRequest.ReadOnly =
    new Wrapper(impl)
}
