package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ClusterSnapshotCopyStatus(
    destinationRegion: Optional[String] = Optional.Absent,
    retentionPeriod: Optional[Long] = Optional.Absent,
    manualSnapshotRetentionPeriod: Optional[Integer] = Optional.Absent,
    snapshotCopyGrantName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ClusterSnapshotCopyStatus = {
    import ClusterSnapshotCopyStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ClusterSnapshotCopyStatus
      .builder()
      .optionallyWith(destinationRegion.map(value => value: java.lang.String))(
        _.destinationRegion
      )
      .optionallyWith(retentionPeriod.map(value => value: java.lang.Long))(
        _.retentionPeriod
      )
      .optionallyWith(
        manualSnapshotRetentionPeriod.map(value => value: java.lang.Integer)
      )(_.manualSnapshotRetentionPeriod)
      .optionallyWith(
        snapshotCopyGrantName.map(value => value: java.lang.String)
      )(_.snapshotCopyGrantName)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.ClusterSnapshotCopyStatus.ReadOnly =
    zio.aws.redshift.model.ClusterSnapshotCopyStatus.wrap(buildAwsValue())
}
object ClusterSnapshotCopyStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ClusterSnapshotCopyStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ClusterSnapshotCopyStatus =
      zio.aws.redshift.model.ClusterSnapshotCopyStatus(
        destinationRegion.map(value => value),
        retentionPeriod.map(value => value),
        manualSnapshotRetentionPeriod.map(value => value),
        snapshotCopyGrantName.map(value => value)
      )
    def destinationRegion: Optional[String]
    def retentionPeriod: Optional[Long]
    def manualSnapshotRetentionPeriod: Optional[Integer]
    def snapshotCopyGrantName: Optional[String]
    def getDestinationRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("destinationRegion", destinationRegion)
    def getRetentionPeriod: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("retentionPeriod", retentionPeriod)
    def getManualSnapshotRetentionPeriod: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "manualSnapshotRetentionPeriod",
        manualSnapshotRetentionPeriod
      )
    def getSnapshotCopyGrantName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotCopyGrantName", snapshotCopyGrantName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ClusterSnapshotCopyStatus
  ) extends zio.aws.redshift.model.ClusterSnapshotCopyStatus.ReadOnly {
    override val destinationRegion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationRegion())
      .map(value => value: String)
    override val retentionPeriod: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.retentionPeriod())
      .map(value => value: Long)
    override val manualSnapshotRetentionPeriod: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manualSnapshotRetentionPeriod())
        .map(value => value: Integer)
    override val snapshotCopyGrantName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotCopyGrantName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ClusterSnapshotCopyStatus
  ): zio.aws.redshift.model.ClusterSnapshotCopyStatus.ReadOnly = new Wrapper(
    impl
  )
}
