package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.{
  PartnerIntegrationPartnerName,
  PartnerIntegrationDatabaseName,
  PartnerIntegrationClusterIdentifier,
  PartnerIntegrationAccountId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AddPartnerRequest(
    accountId: PartnerIntegrationAccountId,
    clusterIdentifier: PartnerIntegrationClusterIdentifier,
    databaseName: PartnerIntegrationDatabaseName,
    partnerName: PartnerIntegrationPartnerName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.AddPartnerRequest = {
    import AddPartnerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.AddPartnerRequest
      .builder()
      .accountId(
        PartnerIntegrationAccountId.unwrap(accountId): java.lang.String
      )
      .clusterIdentifier(
        PartnerIntegrationClusterIdentifier.unwrap(
          clusterIdentifier
        ): java.lang.String
      )
      .databaseName(
        PartnerIntegrationDatabaseName.unwrap(databaseName): java.lang.String
      )
      .partnerName(
        PartnerIntegrationPartnerName.unwrap(partnerName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.AddPartnerRequest.ReadOnly =
    zio.aws.redshift.model.AddPartnerRequest.wrap(buildAwsValue())
}
object AddPartnerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.AddPartnerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.AddPartnerRequest =
      zio.aws.redshift.model.AddPartnerRequest(
        accountId,
        clusterIdentifier,
        databaseName,
        partnerName
      )
    def accountId: PartnerIntegrationAccountId
    def clusterIdentifier: PartnerIntegrationClusterIdentifier
    def databaseName: PartnerIntegrationDatabaseName
    def partnerName: PartnerIntegrationPartnerName
    def getAccountId: ZIO[Any, Nothing, PartnerIntegrationAccountId] =
      ZIO.succeed(accountId)
    def getClusterIdentifier
        : ZIO[Any, Nothing, PartnerIntegrationClusterIdentifier] =
      ZIO.succeed(clusterIdentifier)
    def getDatabaseName: ZIO[Any, Nothing, PartnerIntegrationDatabaseName] =
      ZIO.succeed(databaseName)
    def getPartnerName: ZIO[Any, Nothing, PartnerIntegrationPartnerName] =
      ZIO.succeed(partnerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.AddPartnerRequest
  ) extends zio.aws.redshift.model.AddPartnerRequest.ReadOnly {
    override val accountId: PartnerIntegrationAccountId =
      zio.aws.redshift.model.primitives
        .PartnerIntegrationAccountId(impl.accountId())
    override val clusterIdentifier: PartnerIntegrationClusterIdentifier =
      zio.aws.redshift.model.primitives
        .PartnerIntegrationClusterIdentifier(impl.clusterIdentifier())
    override val databaseName: PartnerIntegrationDatabaseName =
      zio.aws.redshift.model.primitives
        .PartnerIntegrationDatabaseName(impl.databaseName())
    override val partnerName: PartnerIntegrationPartnerName =
      zio.aws.redshift.model.primitives
        .PartnerIntegrationPartnerName(impl.partnerName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.AddPartnerRequest
  ): zio.aws.redshift.model.AddPartnerRequest.ReadOnly = new Wrapper(impl)
}
