package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RestoreTableFromClusterSnapshotResponse(
    tableRestoreStatus: Optional[zio.aws.redshift.model.TableRestoreStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.RestoreTableFromClusterSnapshotResponse = {
    import RestoreTableFromClusterSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.RestoreTableFromClusterSnapshotResponse
      .builder()
      .optionallyWith(tableRestoreStatus.map(value => value.buildAwsValue()))(
        _.tableRestoreStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.RestoreTableFromClusterSnapshotResponse.ReadOnly =
    zio.aws.redshift.model.RestoreTableFromClusterSnapshotResponse
      .wrap(buildAwsValue())
}
object RestoreTableFromClusterSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.RestoreTableFromClusterSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.RestoreTableFromClusterSnapshotResponse =
      zio.aws.redshift.model.RestoreTableFromClusterSnapshotResponse(
        tableRestoreStatus.map(value => value.asEditable)
      )
    def tableRestoreStatus
        : Optional[zio.aws.redshift.model.TableRestoreStatus.ReadOnly]
    def getTableRestoreStatus: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.TableRestoreStatus.ReadOnly
    ] = AwsError.unwrapOptionField("tableRestoreStatus", tableRestoreStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.RestoreTableFromClusterSnapshotResponse
  ) extends zio.aws.redshift.model.RestoreTableFromClusterSnapshotResponse.ReadOnly {
    override val tableRestoreStatus
        : Optional[zio.aws.redshift.model.TableRestoreStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tableRestoreStatus())
        .map(value => zio.aws.redshift.model.TableRestoreStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.RestoreTableFromClusterSnapshotResponse
  ): zio.aws.redshift.model.RestoreTableFromClusterSnapshotResponse.ReadOnly =
    new Wrapper(impl)
}
