package zio.aws.redshift.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeReservedNodesRequest(
    reservedNodeId: Optional[String] = Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeReservedNodesRequest = {
    import DescribeReservedNodesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeReservedNodesRequest
      .builder()
      .optionallyWith(reservedNodeId.map(value => value: java.lang.String))(
        _.reservedNodeId
      )
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.DescribeReservedNodesRequest.ReadOnly =
    zio.aws.redshift.model.DescribeReservedNodesRequest.wrap(buildAwsValue())
}
object DescribeReservedNodesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeReservedNodesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeReservedNodesRequest =
      zio.aws.redshift.model.DescribeReservedNodesRequest(
        reservedNodeId.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def reservedNodeId: Optional[String]
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def getReservedNodeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reservedNodeId", reservedNodeId)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeReservedNodesRequest
  ) extends zio.aws.redshift.model.DescribeReservedNodesRequest.ReadOnly {
    override val reservedNodeId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.reservedNodeId())
      .map(value => value: String)
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeReservedNodesRequest
  ): zio.aws.redshift.model.DescribeReservedNodesRequest.ReadOnly = new Wrapper(
    impl
  )
}
