package zio.aws.redshift.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.{BooleanOptional, IntegerOptional}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class RestoreFromClusterSnapshotRequest(
    clusterIdentifier: String,
    snapshotIdentifier: String,
    snapshotClusterIdentifier: Optional[String] = Optional.Absent,
    port: Optional[IntegerOptional] = Optional.Absent,
    availabilityZone: Optional[String] = Optional.Absent,
    allowVersionUpgrade: Optional[BooleanOptional] = Optional.Absent,
    clusterSubnetGroupName: Optional[String] = Optional.Absent,
    publiclyAccessible: Optional[BooleanOptional] = Optional.Absent,
    ownerAccount: Optional[String] = Optional.Absent,
    hsmClientCertificateIdentifier: Optional[String] = Optional.Absent,
    hsmConfigurationIdentifier: Optional[String] = Optional.Absent,
    elasticIp: Optional[String] = Optional.Absent,
    clusterParameterGroupName: Optional[String] = Optional.Absent,
    clusterSecurityGroups: Optional[Iterable[String]] = Optional.Absent,
    vpcSecurityGroupIds: Optional[Iterable[String]] = Optional.Absent,
    preferredMaintenanceWindow: Optional[String] = Optional.Absent,
    automatedSnapshotRetentionPeriod: Optional[IntegerOptional] =
      Optional.Absent,
    manualSnapshotRetentionPeriod: Optional[IntegerOptional] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    nodeType: Optional[String] = Optional.Absent,
    enhancedVpcRouting: Optional[BooleanOptional] = Optional.Absent,
    additionalInfo: Optional[String] = Optional.Absent,
    iamRoles: Optional[Iterable[String]] = Optional.Absent,
    maintenanceTrackName: Optional[String] = Optional.Absent,
    snapshotScheduleIdentifier: Optional[String] = Optional.Absent,
    numberOfNodes: Optional[IntegerOptional] = Optional.Absent,
    availabilityZoneRelocation: Optional[BooleanOptional] = Optional.Absent,
    aquaConfigurationStatus: Optional[
      zio.aws.redshift.model.AquaConfigurationStatus
    ] = Optional.Absent,
    defaultIamRoleArn: Optional[String] = Optional.Absent,
    reservedNodeId: Optional[String] = Optional.Absent,
    targetReservedNodeOfferingId: Optional[String] = Optional.Absent,
    encrypted: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.RestoreFromClusterSnapshotRequest = {
    import RestoreFromClusterSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.RestoreFromClusterSnapshotRequest
      .builder()
      .clusterIdentifier(clusterIdentifier: java.lang.String)
      .snapshotIdentifier(snapshotIdentifier: java.lang.String)
      .optionallyWith(
        snapshotClusterIdentifier.map(value => value: java.lang.String)
      )(_.snapshotClusterIdentifier)
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(
        allowVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.allowVersionUpgrade)
      .optionallyWith(
        clusterSubnetGroupName.map(value => value: java.lang.String)
      )(_.clusterSubnetGroupName)
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(ownerAccount.map(value => value: java.lang.String))(
        _.ownerAccount
      )
      .optionallyWith(
        hsmClientCertificateIdentifier.map(value => value: java.lang.String)
      )(_.hsmClientCertificateIdentifier)
      .optionallyWith(
        hsmConfigurationIdentifier.map(value => value: java.lang.String)
      )(_.hsmConfigurationIdentifier)
      .optionallyWith(elasticIp.map(value => value: java.lang.String))(
        _.elasticIp
      )
      .optionallyWith(
        clusterParameterGroupName.map(value => value: java.lang.String)
      )(_.clusterParameterGroupName)
      .optionallyWith(
        clusterSecurityGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.clusterSecurityGroups)
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        automatedSnapshotRetentionPeriod.map(value => value: Integer)
      )(_.automatedSnapshotRetentionPeriod)
      .optionallyWith(
        manualSnapshotRetentionPeriod.map(value => value: Integer)
      )(_.manualSnapshotRetentionPeriod)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(nodeType.map(value => value: java.lang.String))(
        _.nodeType
      )
      .optionallyWith(
        enhancedVpcRouting.map(value => value: java.lang.Boolean)
      )(_.enhancedVpcRouting)
      .optionallyWith(additionalInfo.map(value => value: java.lang.String))(
        _.additionalInfo
      )
      .optionallyWith(
        iamRoles.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.iamRoles)
      .optionallyWith(
        maintenanceTrackName.map(value => value: java.lang.String)
      )(_.maintenanceTrackName)
      .optionallyWith(
        snapshotScheduleIdentifier.map(value => value: java.lang.String)
      )(_.snapshotScheduleIdentifier)
      .optionallyWith(numberOfNodes.map(value => value: Integer))(
        _.numberOfNodes
      )
      .optionallyWith(
        availabilityZoneRelocation.map(value => value: java.lang.Boolean)
      )(_.availabilityZoneRelocation)
      .optionallyWith(aquaConfigurationStatus.map(value => value.unwrap))(
        _.aquaConfigurationStatus
      )
      .optionallyWith(defaultIamRoleArn.map(value => value: java.lang.String))(
        _.defaultIamRoleArn
      )
      .optionallyWith(reservedNodeId.map(value => value: java.lang.String))(
        _.reservedNodeId
      )
      .optionallyWith(
        targetReservedNodeOfferingId.map(value => value: java.lang.String)
      )(_.targetReservedNodeOfferingId)
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.RestoreFromClusterSnapshotRequest.ReadOnly =
    zio.aws.redshift.model.RestoreFromClusterSnapshotRequest
      .wrap(buildAwsValue())
}
object RestoreFromClusterSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.RestoreFromClusterSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.RestoreFromClusterSnapshotRequest =
      zio.aws.redshift.model.RestoreFromClusterSnapshotRequest(
        clusterIdentifier,
        snapshotIdentifier,
        snapshotClusterIdentifier.map(value => value),
        port.map(value => value),
        availabilityZone.map(value => value),
        allowVersionUpgrade.map(value => value),
        clusterSubnetGroupName.map(value => value),
        publiclyAccessible.map(value => value),
        ownerAccount.map(value => value),
        hsmClientCertificateIdentifier.map(value => value),
        hsmConfigurationIdentifier.map(value => value),
        elasticIp.map(value => value),
        clusterParameterGroupName.map(value => value),
        clusterSecurityGroups.map(value => value),
        vpcSecurityGroupIds.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        automatedSnapshotRetentionPeriod.map(value => value),
        manualSnapshotRetentionPeriod.map(value => value),
        kmsKeyId.map(value => value),
        nodeType.map(value => value),
        enhancedVpcRouting.map(value => value),
        additionalInfo.map(value => value),
        iamRoles.map(value => value),
        maintenanceTrackName.map(value => value),
        snapshotScheduleIdentifier.map(value => value),
        numberOfNodes.map(value => value),
        availabilityZoneRelocation.map(value => value),
        aquaConfigurationStatus.map(value => value),
        defaultIamRoleArn.map(value => value),
        reservedNodeId.map(value => value),
        targetReservedNodeOfferingId.map(value => value),
        encrypted.map(value => value)
      )
    def clusterIdentifier: String
    def snapshotIdentifier: String
    def snapshotClusterIdentifier: Optional[String]
    def port: Optional[IntegerOptional]
    def availabilityZone: Optional[String]
    def allowVersionUpgrade: Optional[BooleanOptional]
    def clusterSubnetGroupName: Optional[String]
    def publiclyAccessible: Optional[BooleanOptional]
    def ownerAccount: Optional[String]
    def hsmClientCertificateIdentifier: Optional[String]
    def hsmConfigurationIdentifier: Optional[String]
    def elasticIp: Optional[String]
    def clusterParameterGroupName: Optional[String]
    def clusterSecurityGroups: Optional[List[String]]
    def vpcSecurityGroupIds: Optional[List[String]]
    def preferredMaintenanceWindow: Optional[String]
    def automatedSnapshotRetentionPeriod: Optional[IntegerOptional]
    def manualSnapshotRetentionPeriod: Optional[IntegerOptional]
    def kmsKeyId: Optional[String]
    def nodeType: Optional[String]
    def enhancedVpcRouting: Optional[BooleanOptional]
    def additionalInfo: Optional[String]
    def iamRoles: Optional[List[String]]
    def maintenanceTrackName: Optional[String]
    def snapshotScheduleIdentifier: Optional[String]
    def numberOfNodes: Optional[IntegerOptional]
    def availabilityZoneRelocation: Optional[BooleanOptional]
    def aquaConfigurationStatus
        : Optional[zio.aws.redshift.model.AquaConfigurationStatus]
    def defaultIamRoleArn: Optional[String]
    def reservedNodeId: Optional[String]
    def targetReservedNodeOfferingId: Optional[String]
    def encrypted: Optional[BooleanOptional]
    def getClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(clusterIdentifier)
    def getSnapshotIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(snapshotIdentifier)
    def getSnapshotClusterIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("snapshotClusterIdentifier", snapshotClusterIdentifier)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getAllowVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("allowVersionUpgrade", allowVersionUpgrade)
    def getClusterSubnetGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("clusterSubnetGroupName", clusterSubnetGroupName)
    def getPubliclyAccessible: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getOwnerAccount: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerAccount", ownerAccount)
    def getHsmClientCertificateIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "hsmClientCertificateIdentifier",
        hsmClientCertificateIdentifier
      )
    def getHsmConfigurationIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "hsmConfigurationIdentifier",
        hsmConfigurationIdentifier
      )
    def getElasticIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("elasticIp", elasticIp)
    def getClusterParameterGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("clusterParameterGroupName", clusterParameterGroupName)
    def getClusterSecurityGroups: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("clusterSecurityGroups", clusterSecurityGroups)
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getAutomatedSnapshotRetentionPeriod
        : ZIO[Any, AwsError, IntegerOptional] = AwsError.unwrapOptionField(
      "automatedSnapshotRetentionPeriod",
      automatedSnapshotRetentionPeriod
    )
    def getManualSnapshotRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "manualSnapshotRetentionPeriod",
        manualSnapshotRetentionPeriod
      )
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeType", nodeType)
    def getEnhancedVpcRouting: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("enhancedVpcRouting", enhancedVpcRouting)
    def getAdditionalInfo: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("additionalInfo", additionalInfo)
    def getIamRoles: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("iamRoles", iamRoles)
    def getMaintenanceTrackName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maintenanceTrackName", maintenanceTrackName)
    def getSnapshotScheduleIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "snapshotScheduleIdentifier",
        snapshotScheduleIdentifier
      )
    def getNumberOfNodes: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numberOfNodes", numberOfNodes)
    def getAvailabilityZoneRelocation: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "availabilityZoneRelocation",
        availabilityZoneRelocation
      )
    def getAquaConfigurationStatus
        : ZIO[Any, AwsError, zio.aws.redshift.model.AquaConfigurationStatus] =
      AwsError.unwrapOptionField(
        "aquaConfigurationStatus",
        aquaConfigurationStatus
      )
    def getDefaultIamRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("defaultIamRoleArn", defaultIamRoleArn)
    def getReservedNodeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reservedNodeId", reservedNodeId)
    def getTargetReservedNodeOfferingId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "targetReservedNodeOfferingId",
        targetReservedNodeOfferingId
      )
    def getEncrypted: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("encrypted", encrypted)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.RestoreFromClusterSnapshotRequest
  ) extends zio.aws.redshift.model.RestoreFromClusterSnapshotRequest.ReadOnly {
    override val clusterIdentifier: String = impl.clusterIdentifier(): String
    override val snapshotIdentifier: String = impl.snapshotIdentifier(): String
    override val snapshotClusterIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotClusterIdentifier())
        .map(value => value: String)
    override val port: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: IntegerOptional)
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val allowVersionUpgrade: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowVersionUpgrade())
        .map(value => value: BooleanOptional)
    override val clusterSubnetGroupName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterSubnetGroupName())
        .map(value => value: String)
    override val publiclyAccessible: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publiclyAccessible())
        .map(value => value: BooleanOptional)
    override val ownerAccount: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerAccount())
      .map(value => value: String)
    override val hsmClientCertificateIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hsmClientCertificateIdentifier())
        .map(value => value: String)
    override val hsmConfigurationIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hsmConfigurationIdentifier())
        .map(value => value: String)
    override val elasticIp: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.elasticIp())
      .map(value => value: String)
    override val clusterParameterGroupName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterParameterGroupName())
        .map(value => value: String)
    override val clusterSecurityGroups: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterSecurityGroups())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val vpcSecurityGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcSecurityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val preferredMaintenanceWindow: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value => value: String)
    override val automatedSnapshotRetentionPeriod: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.automatedSnapshotRetentionPeriod())
        .map(value => value: IntegerOptional)
    override val manualSnapshotRetentionPeriod: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manualSnapshotRetentionPeriod())
        .map(value => value: IntegerOptional)
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val nodeType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeType())
      .map(value => value: String)
    override val enhancedVpcRouting: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enhancedVpcRouting())
        .map(value => value: BooleanOptional)
    override val additionalInfo: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalInfo())
      .map(value => value: String)
    override val iamRoles: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.iamRoles())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val maintenanceTrackName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.maintenanceTrackName())
      .map(value => value: String)
    override val snapshotScheduleIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotScheduleIdentifier())
        .map(value => value: String)
    override val numberOfNodes: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfNodes())
        .map(value => value: IntegerOptional)
    override val availabilityZoneRelocation: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZoneRelocation())
        .map(value => value: BooleanOptional)
    override val aquaConfigurationStatus
        : Optional[zio.aws.redshift.model.AquaConfigurationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aquaConfigurationStatus())
        .map(value =>
          zio.aws.redshift.model.AquaConfigurationStatus.wrap(value)
        )
    override val defaultIamRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultIamRoleArn())
      .map(value => value: String)
    override val reservedNodeId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.reservedNodeId())
      .map(value => value: String)
    override val targetReservedNodeOfferingId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetReservedNodeOfferingId())
        .map(value => value: String)
    override val encrypted: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.encrypted())
      .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.RestoreFromClusterSnapshotRequest
  ): zio.aws.redshift.model.RestoreFromClusterSnapshotRequest.ReadOnly =
    new Wrapper(impl)
}
