package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ClusterAssociatedToSchedule(
    clusterIdentifier: Optional[String] = Optional.Absent,
    scheduleAssociationState: Optional[zio.aws.redshift.model.ScheduleState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ClusterAssociatedToSchedule = {
    import ClusterAssociatedToSchedule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ClusterAssociatedToSchedule
      .builder()
      .optionallyWith(clusterIdentifier.map(value => value: java.lang.String))(
        _.clusterIdentifier
      )
      .optionallyWith(scheduleAssociationState.map(value => value.unwrap))(
        _.scheduleAssociationState
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.ClusterAssociatedToSchedule.ReadOnly =
    zio.aws.redshift.model.ClusterAssociatedToSchedule.wrap(buildAwsValue())
}
object ClusterAssociatedToSchedule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ClusterAssociatedToSchedule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ClusterAssociatedToSchedule =
      zio.aws.redshift.model.ClusterAssociatedToSchedule(
        clusterIdentifier.map(value => value),
        scheduleAssociationState.map(value => value)
      )
    def clusterIdentifier: Optional[String]
    def scheduleAssociationState: Optional[zio.aws.redshift.model.ScheduleState]
    def getClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getScheduleAssociationState
        : ZIO[Any, AwsError, zio.aws.redshift.model.ScheduleState] = AwsError
      .unwrapOptionField("scheduleAssociationState", scheduleAssociationState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ClusterAssociatedToSchedule
  ) extends zio.aws.redshift.model.ClusterAssociatedToSchedule.ReadOnly {
    override val clusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterIdentifier())
      .map(value => value: String)
    override val scheduleAssociationState
        : Optional[zio.aws.redshift.model.ScheduleState] = zio.aws.core.internal
      .optionalFromNullable(impl.scheduleAssociationState())
      .map(value => zio.aws.redshift.model.ScheduleState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ClusterAssociatedToSchedule
  ): zio.aws.redshift.model.ClusterAssociatedToSchedule.ReadOnly = new Wrapper(
    impl
  )
}
