package zio.aws.redshift.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.TStamp
import scala.jdk.CollectionConverters._
final case class DisableLoggingResponse(
    loggingEnabled: Optional[Boolean] = Optional.Absent,
    bucketName: Optional[String] = Optional.Absent,
    s3KeyPrefix: Optional[String] = Optional.Absent,
    lastSuccessfulDeliveryTime: Optional[TStamp] = Optional.Absent,
    lastFailureTime: Optional[TStamp] = Optional.Absent,
    lastFailureMessage: Optional[String] = Optional.Absent,
    logDestinationType: Optional[zio.aws.redshift.model.LogDestinationType] =
      Optional.Absent,
    logExports: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DisableLoggingResponse = {
    import DisableLoggingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DisableLoggingResponse
      .builder()
      .optionallyWith(loggingEnabled.map(value => value: java.lang.Boolean))(
        _.loggingEnabled
      )
      .optionallyWith(bucketName.map(value => value: java.lang.String))(
        _.bucketName
      )
      .optionallyWith(s3KeyPrefix.map(value => value: java.lang.String))(
        _.s3KeyPrefix
      )
      .optionallyWith(
        lastSuccessfulDeliveryTime.map(value => TStamp.unwrap(value): Instant)
      )(_.lastSuccessfulDeliveryTime)
      .optionallyWith(
        lastFailureTime.map(value => TStamp.unwrap(value): Instant)
      )(_.lastFailureTime)
      .optionallyWith(lastFailureMessage.map(value => value: java.lang.String))(
        _.lastFailureMessage
      )
      .optionallyWith(logDestinationType.map(value => value.unwrap))(
        _.logDestinationType
      )
      .optionallyWith(
        logExports.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.logExports)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.DisableLoggingResponse.ReadOnly =
    zio.aws.redshift.model.DisableLoggingResponse.wrap(buildAwsValue())
}
object DisableLoggingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DisableLoggingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DisableLoggingResponse =
      zio.aws.redshift.model.DisableLoggingResponse(
        loggingEnabled.map(value => value),
        bucketName.map(value => value),
        s3KeyPrefix.map(value => value),
        lastSuccessfulDeliveryTime.map(value => value),
        lastFailureTime.map(value => value),
        lastFailureMessage.map(value => value),
        logDestinationType.map(value => value),
        logExports.map(value => value)
      )
    def loggingEnabled: Optional[Boolean]
    def bucketName: Optional[String]
    def s3KeyPrefix: Optional[String]
    def lastSuccessfulDeliveryTime: Optional[TStamp]
    def lastFailureTime: Optional[TStamp]
    def lastFailureMessage: Optional[String]
    def logDestinationType: Optional[zio.aws.redshift.model.LogDestinationType]
    def logExports: Optional[List[String]]
    def getLoggingEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("loggingEnabled", loggingEnabled)
    def getBucketName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bucketName", bucketName)
    def getS3KeyPrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3KeyPrefix", s3KeyPrefix)
    def getLastSuccessfulDeliveryTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField(
        "lastSuccessfulDeliveryTime",
        lastSuccessfulDeliveryTime
      )
    def getLastFailureTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("lastFailureTime", lastFailureTime)
    def getLastFailureMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastFailureMessage", lastFailureMessage)
    def getLogDestinationType
        : ZIO[Any, AwsError, zio.aws.redshift.model.LogDestinationType] =
      AwsError.unwrapOptionField("logDestinationType", logDestinationType)
    def getLogExports: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("logExports", logExports)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DisableLoggingResponse
  ) extends zio.aws.redshift.model.DisableLoggingResponse.ReadOnly {
    override val loggingEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.loggingEnabled())
      .map(value => value: Boolean)
    override val bucketName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketName())
      .map(value => value: String)
    override val s3KeyPrefix: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.s3KeyPrefix())
      .map(value => value: String)
    override val lastSuccessfulDeliveryTime: Optional[TStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastSuccessfulDeliveryTime())
        .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val lastFailureTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastFailureTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val lastFailureMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lastFailureMessage())
      .map(value => value: String)
    override val logDestinationType
        : Optional[zio.aws.redshift.model.LogDestinationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logDestinationType())
        .map(value => zio.aws.redshift.model.LogDestinationType.wrap(value))
    override val logExports: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.logExports())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DisableLoggingResponse
  ): zio.aws.redshift.model.DisableLoggingResponse.ReadOnly = new Wrapper(impl)
}
