package zio.aws.redshift.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeEndpointAccessRequest(
    clusterIdentifier: Optional[String] = Optional.Absent,
    resourceOwner: Optional[String] = Optional.Absent,
    endpointName: Optional[String] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeEndpointAccessRequest = {
    import DescribeEndpointAccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeEndpointAccessRequest
      .builder()
      .optionallyWith(clusterIdentifier.map(value => value: java.lang.String))(
        _.clusterIdentifier
      )
      .optionallyWith(resourceOwner.map(value => value: java.lang.String))(
        _.resourceOwner
      )
      .optionallyWith(endpointName.map(value => value: java.lang.String))(
        _.endpointName
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeEndpointAccessRequest.ReadOnly =
    zio.aws.redshift.model.DescribeEndpointAccessRequest.wrap(buildAwsValue())
}
object DescribeEndpointAccessRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeEndpointAccessRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeEndpointAccessRequest =
      zio.aws.redshift.model.DescribeEndpointAccessRequest(
        clusterIdentifier.map(value => value),
        resourceOwner.map(value => value),
        endpointName.map(value => value),
        vpcId.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def clusterIdentifier: Optional[String]
    def resourceOwner: Optional[String]
    def endpointName: Optional[String]
    def vpcId: Optional[String]
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def getClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getResourceOwner: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceOwner", resourceOwner)
    def getEndpointName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpointName", endpointName)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeEndpointAccessRequest
  ) extends zio.aws.redshift.model.DescribeEndpointAccessRequest.ReadOnly {
    override val clusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterIdentifier())
      .map(value => value: String)
    override val resourceOwner: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceOwner())
      .map(value => value: String)
    override val endpointName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointName())
      .map(value => value: String)
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeEndpointAccessRequest
  ): zio.aws.redshift.model.DescribeEndpointAccessRequest.ReadOnly =
    new Wrapper(impl)
}
