package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.{
  PartnerIntegrationPartnerName,
  PartnerIntegrationDatabaseName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AddPartnerResponse(
    databaseName: Optional[PartnerIntegrationDatabaseName] = Optional.Absent,
    partnerName: Optional[PartnerIntegrationPartnerName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.AddPartnerResponse = {
    import AddPartnerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.AddPartnerResponse
      .builder()
      .optionallyWith(
        databaseName.map(value =>
          PartnerIntegrationDatabaseName.unwrap(value): java.lang.String
        )
      )(_.databaseName)
      .optionallyWith(
        partnerName.map(value =>
          PartnerIntegrationPartnerName.unwrap(value): java.lang.String
        )
      )(_.partnerName)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.AddPartnerResponse.ReadOnly =
    zio.aws.redshift.model.AddPartnerResponse.wrap(buildAwsValue())
}
object AddPartnerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.AddPartnerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.AddPartnerResponse =
      zio.aws.redshift.model.AddPartnerResponse(
        databaseName.map(value => value),
        partnerName.map(value => value)
      )
    def databaseName: Optional[PartnerIntegrationDatabaseName]
    def partnerName: Optional[PartnerIntegrationPartnerName]
    def getDatabaseName: ZIO[Any, AwsError, PartnerIntegrationDatabaseName] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getPartnerName: ZIO[Any, AwsError, PartnerIntegrationPartnerName] =
      AwsError.unwrapOptionField("partnerName", partnerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.AddPartnerResponse
  ) extends zio.aws.redshift.model.AddPartnerResponse.ReadOnly {
    override val databaseName: Optional[PartnerIntegrationDatabaseName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.databaseName())
        .map(value =>
          zio.aws.redshift.model.primitives
            .PartnerIntegrationDatabaseName(value)
        )
    override val partnerName: Optional[PartnerIntegrationPartnerName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.partnerName())
        .map(value =>
          zio.aws.redshift.model.primitives.PartnerIntegrationPartnerName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.AddPartnerResponse
  ): zio.aws.redshift.model.AddPartnerResponse.ReadOnly = new Wrapper(impl)
}
