package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeClusterSubnetGroupsResponse(
    marker: Optional[String] = Optional.Absent,
    clusterSubnetGroups: Optional[
      Iterable[zio.aws.redshift.model.ClusterSubnetGroup]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsResponse = {
    import DescribeClusterSubnetGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        clusterSubnetGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusterSubnetGroups)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeClusterSubnetGroupsResponse.ReadOnly =
    zio.aws.redshift.model.DescribeClusterSubnetGroupsResponse
      .wrap(buildAwsValue())
}
object DescribeClusterSubnetGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeClusterSubnetGroupsResponse =
      zio.aws.redshift.model.DescribeClusterSubnetGroupsResponse(
        marker.map(value => value),
        clusterSubnetGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def clusterSubnetGroups
        : Optional[List[zio.aws.redshift.model.ClusterSubnetGroup.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getClusterSubnetGroups: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.ClusterSubnetGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("clusterSubnetGroups", clusterSubnetGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsResponse
  ) extends zio.aws.redshift.model.DescribeClusterSubnetGroupsResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val clusterSubnetGroups
        : Optional[List[zio.aws.redshift.model.ClusterSubnetGroup.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterSubnetGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.ClusterSubnetGroup.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsResponse
  ): zio.aws.redshift.model.DescribeClusterSubnetGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
