package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SnapshotCopyGrant(
    snapshotCopyGrantName: Optional[String] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.redshift.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.SnapshotCopyGrant = {
    import SnapshotCopyGrant.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.SnapshotCopyGrant
      .builder()
      .optionallyWith(
        snapshotCopyGrantName.map(value => value: java.lang.String)
      )(_.snapshotCopyGrantName)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.SnapshotCopyGrant.ReadOnly =
    zio.aws.redshift.model.SnapshotCopyGrant.wrap(buildAwsValue())
}
object SnapshotCopyGrant {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.SnapshotCopyGrant
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.SnapshotCopyGrant =
      zio.aws.redshift.model.SnapshotCopyGrant(
        snapshotCopyGrantName.map(value => value),
        kmsKeyId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def snapshotCopyGrantName: Optional[String]
    def kmsKeyId: Optional[String]
    def tags: Optional[List[zio.aws.redshift.model.Tag.ReadOnly]]
    def getSnapshotCopyGrantName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotCopyGrantName", snapshotCopyGrantName)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getTags: ZIO[Any, AwsError, List[zio.aws.redshift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.SnapshotCopyGrant
  ) extends zio.aws.redshift.model.SnapshotCopyGrant.ReadOnly {
    override val snapshotCopyGrantName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotCopyGrantName())
      .map(value => value: String)
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.redshift.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.SnapshotCopyGrant
  ): zio.aws.redshift.model.SnapshotCopyGrant.ReadOnly = new Wrapper(impl)
}
