package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.AuthenticationProfileNameString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyAuthenticationProfileResponse(
    authenticationProfileName: Optional[AuthenticationProfileNameString] =
      Optional.Absent,
    authenticationProfileContent: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ModifyAuthenticationProfileResponse = {
    import ModifyAuthenticationProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ModifyAuthenticationProfileResponse
      .builder()
      .optionallyWith(
        authenticationProfileName.map(value =>
          AuthenticationProfileNameString.unwrap(value): java.lang.String
        )
      )(_.authenticationProfileName)
      .optionallyWith(
        authenticationProfileContent.map(value => value: java.lang.String)
      )(_.authenticationProfileContent)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.ModifyAuthenticationProfileResponse.ReadOnly =
    zio.aws.redshift.model.ModifyAuthenticationProfileResponse
      .wrap(buildAwsValue())
}
object ModifyAuthenticationProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ModifyAuthenticationProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ModifyAuthenticationProfileResponse =
      zio.aws.redshift.model.ModifyAuthenticationProfileResponse(
        authenticationProfileName.map(value => value),
        authenticationProfileContent.map(value => value)
      )
    def authenticationProfileName: Optional[AuthenticationProfileNameString]
    def authenticationProfileContent: Optional[String]
    def getAuthenticationProfileName
        : ZIO[Any, AwsError, AuthenticationProfileNameString] = AwsError
      .unwrapOptionField("authenticationProfileName", authenticationProfileName)
    def getAuthenticationProfileContent: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "authenticationProfileContent",
        authenticationProfileContent
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ModifyAuthenticationProfileResponse
  ) extends zio.aws.redshift.model.ModifyAuthenticationProfileResponse.ReadOnly {
    override val authenticationProfileName
        : Optional[AuthenticationProfileNameString] = zio.aws.core.internal
      .optionalFromNullable(impl.authenticationProfileName())
      .map(value =>
        zio.aws.redshift.model.primitives.AuthenticationProfileNameString(value)
      )
    override val authenticationProfileContent: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationProfileContent())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ModifyAuthenticationProfileResponse
  ): zio.aws.redshift.model.ModifyAuthenticationProfileResponse.ReadOnly =
    new Wrapper(impl)
}
