package zio.aws.redshift.model
import scala.jdk.CollectionConverters._
sealed trait LogDestinationType {
  def unwrap: software.amazon.awssdk.services.redshift.model.LogDestinationType
}
object LogDestinationType {
  def wrap(
      value: software.amazon.awssdk.services.redshift.model.LogDestinationType
  ): zio.aws.redshift.model.LogDestinationType = value match {
    case software.amazon.awssdk.services.redshift.model.LogDestinationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.redshift.model.LogDestinationType.S3 =>
      val r = s3
      r
    case software.amazon.awssdk.services.redshift.model.LogDestinationType.CLOUDWATCH =>
      val r = cloudwatch
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.redshift.model.LogDestinationType {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.LogDestinationType =
      software.amazon.awssdk.services.redshift.model.LogDestinationType.UNKNOWN_TO_SDK_VERSION
  }
  case object s3 extends zio.aws.redshift.model.LogDestinationType {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.LogDestinationType =
      software.amazon.awssdk.services.redshift.model.LogDestinationType.S3
  }
  case object cloudwatch extends zio.aws.redshift.model.LogDestinationType {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.LogDestinationType =
      software.amazon.awssdk.services.redshift.model.LogDestinationType.CLOUDWATCH
  }
}
