package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeClustersResponse(
    marker: Optional[String] = Optional.Absent,
    clusters: Optional[Iterable[zio.aws.redshift.model.Cluster]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeClustersResponse = {
    import DescribeClustersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeClustersResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        clusters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusters)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.DescribeClustersResponse.ReadOnly =
    zio.aws.redshift.model.DescribeClustersResponse.wrap(buildAwsValue())
}
object DescribeClustersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeClustersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeClustersResponse =
      zio.aws.redshift.model.DescribeClustersResponse(
        marker.map(value => value),
        clusters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def clusters: Optional[List[zio.aws.redshift.model.Cluster.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getClusters
        : ZIO[Any, AwsError, List[zio.aws.redshift.model.Cluster.ReadOnly]] =
      AwsError.unwrapOptionField("clusters", clusters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeClustersResponse
  ) extends zio.aws.redshift.model.DescribeClustersResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val clusters
        : Optional[List[zio.aws.redshift.model.Cluster.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.Cluster.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeClustersResponse
  ): zio.aws.redshift.model.DescribeClustersResponse.ReadOnly = new Wrapper(
    impl
  )
}
