package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeUsageLimitsResponse(
    usageLimits: Optional[Iterable[zio.aws.redshift.model.UsageLimit]] =
      Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeUsageLimitsResponse = {
    import DescribeUsageLimitsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeUsageLimitsResponse
      .builder()
      .optionallyWith(
        usageLimits.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.usageLimits)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.DescribeUsageLimitsResponse.ReadOnly =
    zio.aws.redshift.model.DescribeUsageLimitsResponse.wrap(buildAwsValue())
}
object DescribeUsageLimitsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeUsageLimitsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeUsageLimitsResponse =
      zio.aws.redshift.model.DescribeUsageLimitsResponse(
        usageLimits.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def usageLimits: Optional[List[zio.aws.redshift.model.UsageLimit.ReadOnly]]
    def marker: Optional[String]
    def getUsageLimits
        : ZIO[Any, AwsError, List[zio.aws.redshift.model.UsageLimit.ReadOnly]] =
      AwsError.unwrapOptionField("usageLimits", usageLimits)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeUsageLimitsResponse
  ) extends zio.aws.redshift.model.DescribeUsageLimitsResponse.ReadOnly {
    override val usageLimits
        : Optional[List[zio.aws.redshift.model.UsageLimit.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.usageLimits())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.UsageLimit.wrap(item)
          }.toList
        )
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeUsageLimitsResponse
  ): zio.aws.redshift.model.DescribeUsageLimitsResponse.ReadOnly = new Wrapper(
    impl
  )
}
