package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ScheduledActionType(
    resizeCluster: Optional[zio.aws.redshift.model.ResizeClusterMessage] =
      Optional.Absent,
    pauseCluster: Optional[zio.aws.redshift.model.PauseClusterMessage] =
      Optional.Absent,
    resumeCluster: Optional[zio.aws.redshift.model.ResumeClusterMessage] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ScheduledActionType = {
    import ScheduledActionType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ScheduledActionType
      .builder()
      .optionallyWith(resizeCluster.map(value => value.buildAwsValue()))(
        _.resizeCluster
      )
      .optionallyWith(pauseCluster.map(value => value.buildAwsValue()))(
        _.pauseCluster
      )
      .optionallyWith(resumeCluster.map(value => value.buildAwsValue()))(
        _.resumeCluster
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.ScheduledActionType.ReadOnly =
    zio.aws.redshift.model.ScheduledActionType.wrap(buildAwsValue())
}
object ScheduledActionType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ScheduledActionType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ScheduledActionType =
      zio.aws.redshift.model.ScheduledActionType(
        resizeCluster.map(value => value.asEditable),
        pauseCluster.map(value => value.asEditable),
        resumeCluster.map(value => value.asEditable)
      )
    def resizeCluster
        : Optional[zio.aws.redshift.model.ResizeClusterMessage.ReadOnly]
    def pauseCluster
        : Optional[zio.aws.redshift.model.PauseClusterMessage.ReadOnly]
    def resumeCluster
        : Optional[zio.aws.redshift.model.ResumeClusterMessage.ReadOnly]
    def getResizeCluster: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.ResizeClusterMessage.ReadOnly
    ] = AwsError.unwrapOptionField("resizeCluster", resizeCluster)
    def getPauseCluster: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.PauseClusterMessage.ReadOnly
    ] = AwsError.unwrapOptionField("pauseCluster", pauseCluster)
    def getResumeCluster: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.ResumeClusterMessage.ReadOnly
    ] = AwsError.unwrapOptionField("resumeCluster", resumeCluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ScheduledActionType
  ) extends zio.aws.redshift.model.ScheduledActionType.ReadOnly {
    override val resizeCluster
        : Optional[zio.aws.redshift.model.ResizeClusterMessage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resizeCluster())
        .map(value => zio.aws.redshift.model.ResizeClusterMessage.wrap(value))
    override val pauseCluster
        : Optional[zio.aws.redshift.model.PauseClusterMessage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pauseCluster())
        .map(value => zio.aws.redshift.model.PauseClusterMessage.wrap(value))
    override val resumeCluster
        : Optional[zio.aws.redshift.model.ResumeClusterMessage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resumeCluster())
        .map(value => zio.aws.redshift.model.ResumeClusterMessage.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ScheduledActionType
  ): zio.aws.redshift.model.ScheduledActionType.ReadOnly = new Wrapper(impl)
}
