package zio.aws.redshift.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ModifyClusterSnapshotRequest(
    snapshotIdentifier: String,
    manualSnapshotRetentionPeriod: Optional[IntegerOptional] = Optional.Absent,
    force: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotRequest = {
    import ModifyClusterSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotRequest
      .builder()
      .snapshotIdentifier(snapshotIdentifier: java.lang.String)
      .optionallyWith(
        manualSnapshotRetentionPeriod.map(value => value: Integer)
      )(_.manualSnapshotRetentionPeriod)
      .optionallyWith(force.map(value => value: java.lang.Boolean))(_.force)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.ModifyClusterSnapshotRequest.ReadOnly =
    zio.aws.redshift.model.ModifyClusterSnapshotRequest.wrap(buildAwsValue())
}
object ModifyClusterSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ModifyClusterSnapshotRequest =
      zio.aws.redshift.model.ModifyClusterSnapshotRequest(
        snapshotIdentifier,
        manualSnapshotRetentionPeriod.map(value => value),
        force.map(value => value)
      )
    def snapshotIdentifier: String
    def manualSnapshotRetentionPeriod: Optional[IntegerOptional]
    def force: Optional[Boolean]
    def getSnapshotIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(snapshotIdentifier)
    def getManualSnapshotRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "manualSnapshotRetentionPeriod",
        manualSnapshotRetentionPeriod
      )
    def getForce: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("force", force)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotRequest
  ) extends zio.aws.redshift.model.ModifyClusterSnapshotRequest.ReadOnly {
    override val snapshotIdentifier: String = impl.snapshotIdentifier(): String
    override val manualSnapshotRetentionPeriod: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manualSnapshotRetentionPeriod())
        .map(value => value: IntegerOptional)
    override val force: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.force())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotRequest
  ): zio.aws.redshift.model.ModifyClusterSnapshotRequest.ReadOnly = new Wrapper(
    impl
  )
}
