package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResizeInfo(
    resizeType: Optional[String] = Optional.Absent,
    allowCancelResize: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ResizeInfo = {
    import ResizeInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ResizeInfo
      .builder()
      .optionallyWith(resizeType.map(value => value: java.lang.String))(
        _.resizeType
      )
      .optionallyWith(allowCancelResize.map(value => value: java.lang.Boolean))(
        _.allowCancelResize
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.ResizeInfo.ReadOnly =
    zio.aws.redshift.model.ResizeInfo.wrap(buildAwsValue())
}
object ResizeInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ResizeInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ResizeInfo =
      zio.aws.redshift.model.ResizeInfo(
        resizeType.map(value => value),
        allowCancelResize.map(value => value)
      )
    def resizeType: Optional[String]
    def allowCancelResize: Optional[Boolean]
    def getResizeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resizeType", resizeType)
    def getAllowCancelResize: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("allowCancelResize", allowCancelResize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ResizeInfo
  ) extends zio.aws.redshift.model.ResizeInfo.ReadOnly {
    override val resizeType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resizeType())
      .map(value => value: String)
    override val allowCancelResize: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.allowCancelResize())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ResizeInfo
  ): zio.aws.redshift.model.ResizeInfo.ReadOnly = new Wrapper(impl)
}
