package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeClusterTracksResponse(
    maintenanceTracks: Optional[
      Iterable[zio.aws.redshift.model.MaintenanceTrack]
    ] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeClusterTracksResponse = {
    import DescribeClusterTracksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeClusterTracksResponse
      .builder()
      .optionallyWith(
        maintenanceTracks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.maintenanceTracks)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeClusterTracksResponse.ReadOnly =
    zio.aws.redshift.model.DescribeClusterTracksResponse.wrap(buildAwsValue())
}
object DescribeClusterTracksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeClusterTracksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeClusterTracksResponse =
      zio.aws.redshift.model.DescribeClusterTracksResponse(
        maintenanceTracks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def maintenanceTracks
        : Optional[List[zio.aws.redshift.model.MaintenanceTrack.ReadOnly]]
    def marker: Optional[String]
    def getMaintenanceTracks: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.MaintenanceTrack.ReadOnly
    ]] = AwsError.unwrapOptionField("maintenanceTracks", maintenanceTracks)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeClusterTracksResponse
  ) extends zio.aws.redshift.model.DescribeClusterTracksResponse.ReadOnly {
    override val maintenanceTracks
        : Optional[List[zio.aws.redshift.model.MaintenanceTrack.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maintenanceTracks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.MaintenanceTrack.wrap(item)
          }.toList
        )
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeClusterTracksResponse
  ): zio.aws.redshift.model.DescribeClusterTracksResponse.ReadOnly =
    new Wrapper(impl)
}
