package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AcceptReservedNodeExchangeRequest(
    reservedNodeId: String,
    targetReservedNodeOfferingId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.AcceptReservedNodeExchangeRequest = {
    import AcceptReservedNodeExchangeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.AcceptReservedNodeExchangeRequest
      .builder()
      .reservedNodeId(reservedNodeId: java.lang.String)
      .targetReservedNodeOfferingId(
        targetReservedNodeOfferingId: java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.AcceptReservedNodeExchangeRequest.ReadOnly =
    zio.aws.redshift.model.AcceptReservedNodeExchangeRequest
      .wrap(buildAwsValue())
}
object AcceptReservedNodeExchangeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.AcceptReservedNodeExchangeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.AcceptReservedNodeExchangeRequest =
      zio.aws.redshift.model.AcceptReservedNodeExchangeRequest(
        reservedNodeId,
        targetReservedNodeOfferingId
      )
    def reservedNodeId: String
    def targetReservedNodeOfferingId: String
    def getReservedNodeId: ZIO[Any, Nothing, String] =
      ZIO.succeed(reservedNodeId)
    def getTargetReservedNodeOfferingId: ZIO[Any, Nothing, String] =
      ZIO.succeed(targetReservedNodeOfferingId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.AcceptReservedNodeExchangeRequest
  ) extends zio.aws.redshift.model.AcceptReservedNodeExchangeRequest.ReadOnly {
    override val reservedNodeId: String = impl.reservedNodeId(): String
    override val targetReservedNodeOfferingId: String =
      impl.targetReservedNodeOfferingId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.AcceptReservedNodeExchangeRequest
  ): zio.aws.redshift.model.AcceptReservedNodeExchangeRequest.ReadOnly =
    new Wrapper(impl)
}
