package zio.aws.redshift
import zio.aws.redshift.model.DescribeDataSharesForProducerResponse.ReadOnly
import zio.aws.redshift.model.{
  DescribeEventCategoriesRequest,
  DescribeHsmConfigurationsRequest,
  DescribeLoggingStatusRequest,
  DescribeSnapshotSchedulesRequest,
  DescribeClusterSubnetGroupsRequest,
  DescribeSnapshotCopyGrantsRequest,
  AuthorizeSnapshotAccessRequest,
  ModifySnapshotScheduleRequest,
  ResizeClusterRequest,
  DescribeReservedNodesRequest,
  DescribeEndpointAuthorizationRequest,
  AuthorizeEndpointAccessRequest,
  ModifyEventSubscriptionRequest,
  ResetClusterParameterGroupRequest,
  AuthorizeDataShareRequest,
  DeauthorizeDataShareRequest,
  DescribeScheduledActionsRequest,
  GetReservedNodeExchangeConfigurationOptionsRequest,
  DisableSnapshotCopyRequest,
  CancelResizeRequest,
  DeleteTagsRequest,
  DescribePartnersRequest,
  CreateEventSubscriptionRequest,
  DescribeClusterSecurityGroupsRequest,
  RevokeSnapshotAccessRequest,
  EnableSnapshotCopyRequest,
  DescribeAuthenticationProfilesRequest,
  DescribeClusterParametersRequest,
  AuthorizeClusterSecurityGroupIngressRequest,
  DeleteSnapshotCopyGrantRequest,
  DeleteClusterSubnetGroupRequest,
  DescribeClusterSnapshotsRequest,
  DescribeOrderableClusterOptionsRequest,
  DescribeHsmClientCertificatesRequest,
  CreateClusterSubnetGroupRequest,
  ModifyClusterParameterGroupRequest,
  DescribeEventsRequest,
  DescribeDataSharesForConsumerRequest,
  ModifySnapshotCopyRetentionPeriodRequest,
  CreateTagsRequest,
  DisassociateDataShareConsumerRequest,
  DescribeReservedNodeExchangeStatusRequest,
  DeleteEventSubscriptionRequest,
  DescribeEndpointAccessRequest,
  RebootClusterRequest,
  DescribeNodeConfigurationOptionsRequest,
  BatchDeleteClusterSnapshotsRequest,
  RejectDataShareRequest,
  CreateClusterSecurityGroupRequest,
  RotateEncryptionKeyRequest,
  CreateClusterRequest,
  DeletePartnerRequest,
  DescribeUsageLimitsRequest,
  ModifyAuthenticationProfileRequest,
  ModifyClusterDbRevisionRequest,
  DescribeDataSharesRequest,
  DescribeDefaultClusterParametersRequest,
  DeleteUsageLimitRequest,
  DescribeClusterVersionsRequest,
  RevokeEndpointAccessRequest,
  DeleteAuthenticationProfileRequest,
  GetReservedNodeExchangeOfferingsRequest,
  RevokeClusterSecurityGroupIngressRequest,
  DeleteClusterRequest,
  DeleteHsmClientCertificateRequest,
  CreateUsageLimitRequest,
  DeleteClusterSnapshotRequest,
  AcceptReservedNodeExchangeRequest,
  DescribeClusterParameterGroupsRequest,
  DescribeClusterTracksRequest,
  ResumeClusterRequest,
  DeleteScheduledActionRequest,
  CreateHsmConfigurationRequest,
  ModifyAquaConfigurationRequest,
  ModifyUsageLimitRequest,
  CreateClusterSnapshotRequest,
  CreateClusterParameterGroupRequest,
  CreateHsmClientCertificateRequest,
  DeleteClusterSecurityGroupRequest,
  RestoreFromClusterSnapshotRequest,
  DescribeTagsRequest,
  DescribeDataSharesForProducerRequest,
  CreateScheduledActionRequest,
  AssociateDataShareConsumerRequest,
  ModifyClusterSnapshotRequest,
  PauseClusterRequest,
  ModifyClusterSnapshotScheduleRequest,
  DescribeTableRestoreStatusRequest,
  BatchModifyClusterSnapshotsRequest,
  AddPartnerRequest,
  CreateSnapshotScheduleRequest,
  DescribeAccountAttributesRequest,
  ModifyEndpointAccessRequest,
  DescribeReservedNodeOfferingsRequest,
  CopyClusterSnapshotRequest,
  DescribeResizeRequest,
  DeleteClusterParameterGroupRequest,
  DeleteHsmConfigurationRequest,
  ModifyClusterRequest,
  ModifyScheduledActionRequest,
  ModifyClusterSubnetGroupRequest,
  DisableLoggingRequest,
  CreateEndpointAccessRequest,
  RestoreTableFromClusterSnapshotRequest,
  ModifyClusterIamRolesRequest,
  DescribeEventSubscriptionsRequest,
  DeleteSnapshotScheduleRequest,
  PurchaseReservedNodeOfferingRequest,
  DescribeClusterDbRevisionsRequest,
  DescribeClustersRequest,
  CreateAuthenticationProfileRequest,
  UpdatePartnerStatusRequest,
  GetClusterCredentialsRequest,
  EnableLoggingRequest,
  DeleteEndpointAccessRequest,
  ModifyClusterMaintenanceRequest,
  CreateSnapshotCopyGrantRequest
}
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object RedshiftMock extends Mock[Redshift] {
  object DeleteHsmConfiguration
      extends Effect[DeleteHsmConfigurationRequest, AwsError, Unit]
  object AuthorizeSnapshotAccess
      extends Effect[
        AuthorizeSnapshotAccessRequest,
        AwsError,
        zio.aws.redshift.model.AuthorizeSnapshotAccessResponse.ReadOnly
      ]
  object DescribeTags
      extends Stream[
        DescribeTagsRequest,
        AwsError,
        zio.aws.redshift.model.TaggedResource.ReadOnly
      ]
  object DescribeTagsPaginated
      extends Effect[
        DescribeTagsRequest,
        AwsError,
        zio.aws.redshift.model.DescribeTagsResponse.ReadOnly
      ]
  object ModifyClusterSubnetGroup
      extends Effect[
        ModifyClusterSubnetGroupRequest,
        AwsError,
        zio.aws.redshift.model.ModifyClusterSubnetGroupResponse.ReadOnly
      ]
  object ResetClusterParameterGroup
      extends Effect[
        ResetClusterParameterGroupRequest,
        AwsError,
        zio.aws.redshift.model.ResetClusterParameterGroupResponse.ReadOnly
      ]
  object DeleteClusterParameterGroup
      extends Effect[DeleteClusterParameterGroupRequest, AwsError, Unit]
  object ResumeCluster
      extends Effect[
        ResumeClusterRequest,
        AwsError,
        zio.aws.redshift.model.ResumeClusterResponse.ReadOnly
      ]
  object DescribeClusters
      extends Stream[
        DescribeClustersRequest,
        AwsError,
        zio.aws.redshift.model.Cluster.ReadOnly
      ]
  object DescribeClustersPaginated
      extends Effect[
        DescribeClustersRequest,
        AwsError,
        zio.aws.redshift.model.DescribeClustersResponse.ReadOnly
      ]
  object ModifyUsageLimit
      extends Effect[
        ModifyUsageLimitRequest,
        AwsError,
        zio.aws.redshift.model.ModifyUsageLimitResponse.ReadOnly
      ]
  object DescribeClusterDbRevisions
      extends Stream[
        DescribeClusterDbRevisionsRequest,
        AwsError,
        zio.aws.redshift.model.ClusterDbRevision.ReadOnly
      ]
  object DescribeClusterDbRevisionsPaginated
      extends Effect[
        DescribeClusterDbRevisionsRequest,
        AwsError,
        zio.aws.redshift.model.DescribeClusterDbRevisionsResponse.ReadOnly
      ]
  object AcceptReservedNodeExchange
      extends Effect[
        AcceptReservedNodeExchangeRequest,
        AwsError,
        zio.aws.redshift.model.AcceptReservedNodeExchangeResponse.ReadOnly
      ]
  object ModifyScheduledAction
      extends Effect[
        ModifyScheduledActionRequest,
        AwsError,
        zio.aws.redshift.model.ModifyScheduledActionResponse.ReadOnly
      ]
  object GetReservedNodeExchangeConfigurationOptions
      extends Stream[
        GetReservedNodeExchangeConfigurationOptionsRequest,
        AwsError,
        zio.aws.redshift.model.ReservedNodeConfigurationOption.ReadOnly
      ]
  object GetReservedNodeExchangeConfigurationOptionsPaginated
      extends Effect[
        GetReservedNodeExchangeConfigurationOptionsRequest,
        AwsError,
        zio.aws.redshift.model.GetReservedNodeExchangeConfigurationOptionsResponse.ReadOnly
      ]
  object DescribeDefaultClusterParameters
      extends Effect[
        DescribeDefaultClusterParametersRequest,
        AwsError,
        zio.aws.redshift.model.DescribeDefaultClusterParametersResponse.ReadOnly
      ]
  object ModifyEndpointAccess
      extends Effect[
        ModifyEndpointAccessRequest,
        AwsError,
        zio.aws.redshift.model.ModifyEndpointAccessResponse.ReadOnly
      ]
  object CreateClusterSecurityGroup
      extends Effect[
        CreateClusterSecurityGroupRequest,
        AwsError,
        zio.aws.redshift.model.CreateClusterSecurityGroupResponse.ReadOnly
      ]
  object BatchDeleteClusterSnapshots
      extends Effect[
        BatchDeleteClusterSnapshotsRequest,
        AwsError,
        zio.aws.redshift.model.BatchDeleteClusterSnapshotsResponse.ReadOnly
      ]
  object CreateAuthenticationProfile
      extends Effect[
        CreateAuthenticationProfileRequest,
        AwsError,
        zio.aws.redshift.model.CreateAuthenticationProfileResponse.ReadOnly
      ]
  object DeleteHsmClientCertificate
      extends Effect[DeleteHsmClientCertificateRequest, AwsError, Unit]
  object DescribeClusterParameterGroups
      extends Stream[
        DescribeClusterParameterGroupsRequest,
        AwsError,
        zio.aws.redshift.model.ClusterParameterGroup.ReadOnly
      ]
  object DescribeClusterParameterGroupsPaginated
      extends Effect[
        DescribeClusterParameterGroupsRequest,
        AwsError,
        zio.aws.redshift.model.DescribeClusterParameterGroupsResponse.ReadOnly
      ]
  object DescribeReservedNodes
      extends Stream[
        DescribeReservedNodesRequest,
        AwsError,
        zio.aws.redshift.model.ReservedNode.ReadOnly
      ]
  object DescribeReservedNodesPaginated
      extends Effect[
        DescribeReservedNodesRequest,
        AwsError,
        zio.aws.redshift.model.DescribeReservedNodesResponse.ReadOnly
      ]
  object DisableSnapshotCopy
      extends Effect[
        DisableSnapshotCopyRequest,
        AwsError,
        zio.aws.redshift.model.DisableSnapshotCopyResponse.ReadOnly
      ]
  object EnableSnapshotCopy
      extends Effect[
        EnableSnapshotCopyRequest,
        AwsError,
        zio.aws.redshift.model.EnableSnapshotCopyResponse.ReadOnly
      ]
  object DescribeClusterVersions
      extends Stream[
        DescribeClusterVersionsRequest,
        AwsError,
        zio.aws.redshift.model.ClusterVersion.ReadOnly
      ]
  object DescribeClusterVersionsPaginated
      extends Effect[
        DescribeClusterVersionsRequest,
        AwsError,
        zio.aws.redshift.model.DescribeClusterVersionsResponse.ReadOnly
      ]
  object ModifyClusterSnapshotSchedule
      extends Effect[ModifyClusterSnapshotScheduleRequest, AwsError, Unit]
  object DeleteSnapshotCopyGrant
      extends Effect[DeleteSnapshotCopyGrantRequest, AwsError, Unit]
  object ModifyAquaConfiguration
      extends Effect[
        ModifyAquaConfigurationRequest,
        AwsError,
        zio.aws.redshift.model.ModifyAquaConfigurationResponse.ReadOnly
      ]
  object DescribeClusterTracks
      extends Stream[
        DescribeClusterTracksRequest,
        AwsError,
        zio.aws.redshift.model.MaintenanceTrack.ReadOnly
      ]
  object DescribeClusterTracksPaginated
      extends Effect[
        DescribeClusterTracksRequest,
        AwsError,
        zio.aws.redshift.model.DescribeClusterTracksResponse.ReadOnly
      ]
  object CreateHsmConfiguration
      extends Effect[
        CreateHsmConfigurationRequest,
        AwsError,
        zio.aws.redshift.model.CreateHsmConfigurationResponse.ReadOnly
      ]
  object DescribeDataSharesForConsumer
      extends Stream[
        DescribeDataSharesForConsumerRequest,
        AwsError,
        zio.aws.redshift.model.DataShare.ReadOnly
      ]
  object DescribeDataSharesForConsumerPaginated
      extends Effect[
        DescribeDataSharesForConsumerRequest,
        AwsError,
        zio.aws.redshift.model.DescribeDataSharesForConsumerResponse.ReadOnly
      ]
  object DeleteEventSubscription
      extends Effect[DeleteEventSubscriptionRequest, AwsError, Unit]
  object ModifyClusterSnapshot
      extends Effect[
        ModifyClusterSnapshotRequest,
        AwsError,
        zio.aws.redshift.model.ModifyClusterSnapshotResponse.ReadOnly
      ]
  object RestoreTableFromClusterSnapshot
      extends Effect[
        RestoreTableFromClusterSnapshotRequest,
        AwsError,
        zio.aws.redshift.model.RestoreTableFromClusterSnapshotResponse.ReadOnly
      ]
  object DescribeUsageLimits
      extends Stream[
        DescribeUsageLimitsRequest,
        AwsError,
        zio.aws.redshift.model.UsageLimit.ReadOnly
      ]
  object DescribeUsageLimitsPaginated
      extends Effect[
        DescribeUsageLimitsRequest,
        AwsError,
        zio.aws.redshift.model.DescribeUsageLimitsResponse.ReadOnly
      ]
  object DescribeResize
      extends Effect[
        DescribeResizeRequest,
        AwsError,
        zio.aws.redshift.model.DescribeResizeResponse.ReadOnly
      ]
  object DeleteSnapshotSchedule
      extends Effect[DeleteSnapshotScheduleRequest, AwsError, Unit]
  object CreateCluster
      extends Effect[
        CreateClusterRequest,
        AwsError,
        zio.aws.redshift.model.CreateClusterResponse.ReadOnly
      ]
  object AssociateDataShareConsumer
      extends Effect[
        AssociateDataShareConsumerRequest,
        AwsError,
        zio.aws.redshift.model.AssociateDataShareConsumerResponse.ReadOnly
      ]
  object DeleteClusterSnapshot
      extends Effect[
        DeleteClusterSnapshotRequest,
        AwsError,
        zio.aws.redshift.model.DeleteClusterSnapshotResponse.ReadOnly
      ]
  object DeleteCluster
      extends Effect[
        DeleteClusterRequest,
        AwsError,
        zio.aws.redshift.model.DeleteClusterResponse.ReadOnly
      ]
  object DeleteUsageLimit
      extends Effect[DeleteUsageLimitRequest, AwsError, Unit]
  object CancelResize
      extends Effect[
        CancelResizeRequest,
        AwsError,
        zio.aws.redshift.model.CancelResizeResponse.ReadOnly
      ]
  object PauseCluster
      extends Effect[
        PauseClusterRequest,
        AwsError,
        zio.aws.redshift.model.PauseClusterResponse.ReadOnly
      ]
  object DeleteEndpointAccess
      extends Effect[
        DeleteEndpointAccessRequest,
        AwsError,
        zio.aws.redshift.model.DeleteEndpointAccessResponse.ReadOnly
      ]
  object ResizeCluster
      extends Effect[
        ResizeClusterRequest,
        AwsError,
        zio.aws.redshift.model.ResizeClusterResponse.ReadOnly
      ]
  object DescribeClusterSecurityGroups
      extends Stream[
        DescribeClusterSecurityGroupsRequest,
        AwsError,
        zio.aws.redshift.model.ClusterSecurityGroup.ReadOnly
      ]
  object DescribeClusterSecurityGroupsPaginated
      extends Effect[
        DescribeClusterSecurityGroupsRequest,
        AwsError,
        zio.aws.redshift.model.DescribeClusterSecurityGroupsResponse.ReadOnly
      ]
  object CreateSnapshotCopyGrant
      extends Effect[
        CreateSnapshotCopyGrantRequest,
        AwsError,
        zio.aws.redshift.model.CreateSnapshotCopyGrantResponse.ReadOnly
      ]
  object DescribeHsmConfigurations
      extends Stream[
        DescribeHsmConfigurationsRequest,
        AwsError,
        zio.aws.redshift.model.HsmConfiguration.ReadOnly
      ]
  object DescribeHsmConfigurationsPaginated
      extends Effect[
        DescribeHsmConfigurationsRequest,
        AwsError,
        zio.aws.redshift.model.DescribeHsmConfigurationsResponse.ReadOnly
      ]
  object DescribeClusterParameters
      extends Stream[
        DescribeClusterParametersRequest,
        AwsError,
        zio.aws.redshift.model.Parameter.ReadOnly
      ]
  object DescribeClusterParametersPaginated
      extends Effect[
        DescribeClusterParametersRequest,
        AwsError,
        zio.aws.redshift.model.DescribeClusterParametersResponse.ReadOnly
      ]
  object CreateEndpointAccess
      extends Effect[
        CreateEndpointAccessRequest,
        AwsError,
        zio.aws.redshift.model.CreateEndpointAccessResponse.ReadOnly
      ]
  object AddPartner
      extends Effect[
        AddPartnerRequest,
        AwsError,
        zio.aws.redshift.model.AddPartnerResponse.ReadOnly
      ]
  object DescribeOrderableClusterOptions
      extends Stream[
        DescribeOrderableClusterOptionsRequest,
        AwsError,
        zio.aws.redshift.model.OrderableClusterOption.ReadOnly
      ]
  object DescribeOrderableClusterOptionsPaginated
      extends Effect[
        DescribeOrderableClusterOptionsRequest,
        AwsError,
        zio.aws.redshift.model.DescribeOrderableClusterOptionsResponse.ReadOnly
      ]
  object ModifyEventSubscription
      extends Effect[
        ModifyEventSubscriptionRequest,
        AwsError,
        zio.aws.redshift.model.ModifyEventSubscriptionResponse.ReadOnly
      ]
  object DescribeLoggingStatus
      extends Effect[
        DescribeLoggingStatusRequest,
        AwsError,
        zio.aws.redshift.model.DescribeLoggingStatusResponse.ReadOnly
      ]
  object CreateHsmClientCertificate
      extends Effect[
        CreateHsmClientCertificateRequest,
        AwsError,
        zio.aws.redshift.model.CreateHsmClientCertificateResponse.ReadOnly
      ]
  object DeletePartner
      extends Effect[
        DeletePartnerRequest,
        AwsError,
        zio.aws.redshift.model.DeletePartnerResponse.ReadOnly
      ]
  object DescribeNodeConfigurationOptions
      extends Stream[
        DescribeNodeConfigurationOptionsRequest,
        AwsError,
        zio.aws.redshift.model.NodeConfigurationOption.ReadOnly
      ]
  object DescribeNodeConfigurationOptionsPaginated
      extends Effect[
        DescribeNodeConfigurationOptionsRequest,
        AwsError,
        zio.aws.redshift.model.DescribeNodeConfigurationOptionsResponse.ReadOnly
      ]
  object DescribeTableRestoreStatus
      extends Stream[
        DescribeTableRestoreStatusRequest,
        AwsError,
        zio.aws.redshift.model.TableRestoreStatus.ReadOnly
      ]
  object DescribeTableRestoreStatusPaginated
      extends Effect[
        DescribeTableRestoreStatusRequest,
        AwsError,
        zio.aws.redshift.model.DescribeTableRestoreStatusResponse.ReadOnly
      ]
  object RebootCluster
      extends Effect[
        RebootClusterRequest,
        AwsError,
        zio.aws.redshift.model.RebootClusterResponse.ReadOnly
      ]
  object EnableLogging
      extends Effect[
        EnableLoggingRequest,
        AwsError,
        zio.aws.redshift.model.EnableLoggingResponse.ReadOnly
      ]
  object RevokeEndpointAccess
      extends Effect[
        RevokeEndpointAccessRequest,
        AwsError,
        zio.aws.redshift.model.RevokeEndpointAccessResponse.ReadOnly
      ]
  object DescribeAuthenticationProfiles
      extends Effect[
        DescribeAuthenticationProfilesRequest,
        AwsError,
        zio.aws.redshift.model.DescribeAuthenticationProfilesResponse.ReadOnly
      ]
  object CreateScheduledAction
      extends Effect[
        CreateScheduledActionRequest,
        AwsError,
        zio.aws.redshift.model.CreateScheduledActionResponse.ReadOnly
      ]
  object DeleteClusterSecurityGroup
      extends Effect[DeleteClusterSecurityGroupRequest, AwsError, Unit]
  object DescribePartners
      extends Effect[
        DescribePartnersRequest,
        AwsError,
        zio.aws.redshift.model.DescribePartnersResponse.ReadOnly
      ]
  object DescribeHsmClientCertificates
      extends Stream[
        DescribeHsmClientCertificatesRequest,
        AwsError,
        zio.aws.redshift.model.HsmClientCertificate.ReadOnly
      ]
  object DescribeHsmClientCertificatesPaginated
      extends Effect[
        DescribeHsmClientCertificatesRequest,
        AwsError,
        zio.aws.redshift.model.DescribeHsmClientCertificatesResponse.ReadOnly
      ]
  object DescribeEventCategories
      extends Effect[
        DescribeEventCategoriesRequest,
        AwsError,
        zio.aws.redshift.model.DescribeEventCategoriesResponse.ReadOnly
      ]
  object ModifyClusterDbRevision
      extends Effect[
        ModifyClusterDbRevisionRequest,
        AwsError,
        zio.aws.redshift.model.ModifyClusterDbRevisionResponse.ReadOnly
      ]
  object CreateSnapshotSchedule
      extends Effect[
        CreateSnapshotScheduleRequest,
        AwsError,
        zio.aws.redshift.model.CreateSnapshotScheduleResponse.ReadOnly
      ]
  object DescribeDataShares
      extends Stream[
        DescribeDataSharesRequest,
        AwsError,
        zio.aws.redshift.model.DataShare.ReadOnly
      ]
  object DescribeDataSharesPaginated
      extends Effect[
        DescribeDataSharesRequest,
        AwsError,
        zio.aws.redshift.model.DescribeDataSharesResponse.ReadOnly
      ]
  object DescribeClusterSnapshots
      extends Stream[
        DescribeClusterSnapshotsRequest,
        AwsError,
        zio.aws.redshift.model.Snapshot.ReadOnly
      ]
  object DescribeClusterSnapshotsPaginated
      extends Effect[
        DescribeClusterSnapshotsRequest,
        AwsError,
        zio.aws.redshift.model.DescribeClusterSnapshotsResponse.ReadOnly
      ]
  object GetReservedNodeExchangeOfferings
      extends Stream[
        GetReservedNodeExchangeOfferingsRequest,
        AwsError,
        zio.aws.redshift.model.ReservedNodeOffering.ReadOnly
      ]
  object GetReservedNodeExchangeOfferingsPaginated
      extends Effect[
        GetReservedNodeExchangeOfferingsRequest,
        AwsError,
        zio.aws.redshift.model.GetReservedNodeExchangeOfferingsResponse.ReadOnly
      ]
  object DescribeStorage
      extends Effect[
        Unit,
        AwsError,
        zio.aws.redshift.model.DescribeStorageResponse.ReadOnly
      ]
  object ModifyCluster
      extends Effect[
        ModifyClusterRequest,
        AwsError,
        zio.aws.redshift.model.ModifyClusterResponse.ReadOnly
      ]
  object AuthorizeDataShare
      extends Effect[
        AuthorizeDataShareRequest,
        AwsError,
        zio.aws.redshift.model.AuthorizeDataShareResponse.ReadOnly
      ]
  object DescribeReservedNodeExchangeStatus
      extends Stream[
        DescribeReservedNodeExchangeStatusRequest,
        AwsError,
        zio.aws.redshift.model.ReservedNodeExchangeStatus.ReadOnly
      ]
  object DescribeReservedNodeExchangeStatusPaginated
      extends Effect[
        DescribeReservedNodeExchangeStatusRequest,
        AwsError,
        zio.aws.redshift.model.DescribeReservedNodeExchangeStatusResponse.ReadOnly
      ]
  object ModifyClusterParameterGroup
      extends Effect[
        ModifyClusterParameterGroupRequest,
        AwsError,
        zio.aws.redshift.model.ModifyClusterParameterGroupResponse.ReadOnly
      ]
  object RevokeSnapshotAccess
      extends Effect[
        RevokeSnapshotAccessRequest,
        AwsError,
        zio.aws.redshift.model.RevokeSnapshotAccessResponse.ReadOnly
      ]
  object CreateEventSubscription
      extends Effect[
        CreateEventSubscriptionRequest,
        AwsError,
        zio.aws.redshift.model.CreateEventSubscriptionResponse.ReadOnly
      ]
  object ModifyClusterMaintenance
      extends Effect[
        ModifyClusterMaintenanceRequest,
        AwsError,
        zio.aws.redshift.model.ModifyClusterMaintenanceResponse.ReadOnly
      ]
  object CreateUsageLimit
      extends Effect[
        CreateUsageLimitRequest,
        AwsError,
        zio.aws.redshift.model.CreateUsageLimitResponse.ReadOnly
      ]
  object ModifySnapshotCopyRetentionPeriod
      extends Effect[
        ModifySnapshotCopyRetentionPeriodRequest,
        AwsError,
        zio.aws.redshift.model.ModifySnapshotCopyRetentionPeriodResponse.ReadOnly
      ]
  object DeauthorizeDataShare
      extends Effect[
        DeauthorizeDataShareRequest,
        AwsError,
        zio.aws.redshift.model.DeauthorizeDataShareResponse.ReadOnly
      ]
  object RotateEncryptionKey
      extends Effect[
        RotateEncryptionKeyRequest,
        AwsError,
        zio.aws.redshift.model.RotateEncryptionKeyResponse.ReadOnly
      ]
  object DescribeEndpointAuthorization
      extends Stream[
        DescribeEndpointAuthorizationRequest,
        AwsError,
        zio.aws.redshift.model.EndpointAuthorization.ReadOnly
      ]
  object DescribeEndpointAuthorizationPaginated
      extends Effect[
        DescribeEndpointAuthorizationRequest,
        AwsError,
        zio.aws.redshift.model.DescribeEndpointAuthorizationResponse.ReadOnly
      ]
  object DescribeScheduledActions
      extends Stream[
        DescribeScheduledActionsRequest,
        AwsError,
        zio.aws.redshift.model.ScheduledAction.ReadOnly
      ]
  object DescribeScheduledActionsPaginated
      extends Effect[
        DescribeScheduledActionsRequest,
        AwsError,
        zio.aws.redshift.model.DescribeScheduledActionsResponse.ReadOnly
      ]
  object ModifyClusterIamRoles
      extends Effect[
        ModifyClusterIamRolesRequest,
        AwsError,
        zio.aws.redshift.model.ModifyClusterIamRolesResponse.ReadOnly
      ]
  object DeleteScheduledAction
      extends Effect[DeleteScheduledActionRequest, AwsError, Unit]
  object GetClusterCredentials
      extends Effect[
        GetClusterCredentialsRequest,
        AwsError,
        zio.aws.redshift.model.GetClusterCredentialsResponse.ReadOnly
      ]
  object RejectDataShare
      extends Effect[
        RejectDataShareRequest,
        AwsError,
        zio.aws.redshift.model.RejectDataShareResponse.ReadOnly
      ]
  object DescribeEventSubscriptions
      extends Stream[
        DescribeEventSubscriptionsRequest,
        AwsError,
        zio.aws.redshift.model.EventSubscription.ReadOnly
      ]
  object DescribeEventSubscriptionsPaginated
      extends Effect[
        DescribeEventSubscriptionsRequest,
        AwsError,
        zio.aws.redshift.model.DescribeEventSubscriptionsResponse.ReadOnly
      ]
  object DeleteAuthenticationProfile
      extends Effect[
        DeleteAuthenticationProfileRequest,
        AwsError,
        zio.aws.redshift.model.DeleteAuthenticationProfileResponse.ReadOnly
      ]
  object CreateClusterParameterGroup
      extends Effect[
        CreateClusterParameterGroupRequest,
        AwsError,
        zio.aws.redshift.model.CreateClusterParameterGroupResponse.ReadOnly
      ]
  object CreateClusterSnapshot
      extends Effect[
        CreateClusterSnapshotRequest,
        AwsError,
        zio.aws.redshift.model.CreateClusterSnapshotResponse.ReadOnly
      ]
  object DescribeSnapshotSchedules
      extends Stream[
        DescribeSnapshotSchedulesRequest,
        AwsError,
        zio.aws.redshift.model.SnapshotSchedule.ReadOnly
      ]
  object DescribeSnapshotSchedulesPaginated
      extends Effect[
        DescribeSnapshotSchedulesRequest,
        AwsError,
        zio.aws.redshift.model.DescribeSnapshotSchedulesResponse.ReadOnly
      ]
  object DescribeClusterSubnetGroups
      extends Stream[
        DescribeClusterSubnetGroupsRequest,
        AwsError,
        zio.aws.redshift.model.ClusterSubnetGroup.ReadOnly
      ]
  object DescribeClusterSubnetGroupsPaginated
      extends Effect[
        DescribeClusterSubnetGroupsRequest,
        AwsError,
        zio.aws.redshift.model.DescribeClusterSubnetGroupsResponse.ReadOnly
      ]
  object CreateClusterSubnetGroup
      extends Effect[
        CreateClusterSubnetGroupRequest,
        AwsError,
        zio.aws.redshift.model.CreateClusterSubnetGroupResponse.ReadOnly
      ]
  object ModifyAuthenticationProfile
      extends Effect[
        ModifyAuthenticationProfileRequest,
        AwsError,
        zio.aws.redshift.model.ModifyAuthenticationProfileResponse.ReadOnly
      ]
  object DescribeDataSharesForProducer
      extends Stream[
        DescribeDataSharesForProducerRequest,
        AwsError,
        zio.aws.redshift.model.DataShare.ReadOnly
      ]
  object DescribeDataSharesForProducerPaginated
      extends Effect[DescribeDataSharesForProducerRequest, AwsError, ReadOnly]
  object DescribeReservedNodeOfferings
      extends Stream[
        DescribeReservedNodeOfferingsRequest,
        AwsError,
        zio.aws.redshift.model.ReservedNodeOffering.ReadOnly
      ]
  object DescribeReservedNodeOfferingsPaginated
      extends Effect[
        DescribeReservedNodeOfferingsRequest,
        AwsError,
        zio.aws.redshift.model.DescribeReservedNodeOfferingsResponse.ReadOnly
      ]
  object ModifySnapshotSchedule
      extends Effect[
        ModifySnapshotScheduleRequest,
        AwsError,
        zio.aws.redshift.model.ModifySnapshotScheduleResponse.ReadOnly
      ]
  object DeleteTags extends Effect[DeleteTagsRequest, AwsError, Unit]
  object PurchaseReservedNodeOffering
      extends Effect[
        PurchaseReservedNodeOfferingRequest,
        AwsError,
        zio.aws.redshift.model.PurchaseReservedNodeOfferingResponse.ReadOnly
      ]
  object DescribeAccountAttributes
      extends Effect[
        DescribeAccountAttributesRequest,
        AwsError,
        zio.aws.redshift.model.DescribeAccountAttributesResponse.ReadOnly
      ]
  object BatchModifyClusterSnapshots
      extends Effect[
        BatchModifyClusterSnapshotsRequest,
        AwsError,
        zio.aws.redshift.model.BatchModifyClusterSnapshotsResponse.ReadOnly
      ]
  object DeleteClusterSubnetGroup
      extends Effect[DeleteClusterSubnetGroupRequest, AwsError, Unit]
  object RevokeClusterSecurityGroupIngress
      extends Effect[
        RevokeClusterSecurityGroupIngressRequest,
        AwsError,
        zio.aws.redshift.model.RevokeClusterSecurityGroupIngressResponse.ReadOnly
      ]
  object AuthorizeClusterSecurityGroupIngress
      extends Effect[
        AuthorizeClusterSecurityGroupIngressRequest,
        AwsError,
        zio.aws.redshift.model.AuthorizeClusterSecurityGroupIngressResponse.ReadOnly
      ]
  object UpdatePartnerStatus
      extends Effect[
        UpdatePartnerStatusRequest,
        AwsError,
        zio.aws.redshift.model.UpdatePartnerStatusResponse.ReadOnly
      ]
  object CopyClusterSnapshot
      extends Effect[
        CopyClusterSnapshotRequest,
        AwsError,
        zio.aws.redshift.model.CopyClusterSnapshotResponse.ReadOnly
      ]
  object DescribeSnapshotCopyGrants
      extends Stream[
        DescribeSnapshotCopyGrantsRequest,
        AwsError,
        zio.aws.redshift.model.SnapshotCopyGrant.ReadOnly
      ]
  object DescribeSnapshotCopyGrantsPaginated
      extends Effect[
        DescribeSnapshotCopyGrantsRequest,
        AwsError,
        zio.aws.redshift.model.DescribeSnapshotCopyGrantsResponse.ReadOnly
      ]
  object AuthorizeEndpointAccess
      extends Effect[
        AuthorizeEndpointAccessRequest,
        AwsError,
        zio.aws.redshift.model.AuthorizeEndpointAccessResponse.ReadOnly
      ]
  object RestoreFromClusterSnapshot
      extends Effect[
        RestoreFromClusterSnapshotRequest,
        AwsError,
        zio.aws.redshift.model.RestoreFromClusterSnapshotResponse.ReadOnly
      ]
  object DisableLogging
      extends Effect[
        DisableLoggingRequest,
        AwsError,
        zio.aws.redshift.model.DisableLoggingResponse.ReadOnly
      ]
  object DisassociateDataShareConsumer
      extends Effect[
        DisassociateDataShareConsumerRequest,
        AwsError,
        zio.aws.redshift.model.DisassociateDataShareConsumerResponse.ReadOnly
      ]
  object DescribeEvents
      extends Stream[
        DescribeEventsRequest,
        AwsError,
        zio.aws.redshift.model.Event.ReadOnly
      ]
  object DescribeEventsPaginated
      extends Effect[
        DescribeEventsRequest,
        AwsError,
        zio.aws.redshift.model.DescribeEventsResponse.ReadOnly
      ]
  object DescribeEndpointAccess
      extends Stream[
        DescribeEndpointAccessRequest,
        AwsError,
        zio.aws.redshift.model.EndpointAccess.ReadOnly
      ]
  object DescribeEndpointAccessPaginated
      extends Effect[
        DescribeEndpointAccessRequest,
        AwsError,
        zio.aws.redshift.model.DescribeEndpointAccessResponse.ReadOnly
      ]
  object CreateTags extends Effect[CreateTagsRequest, AwsError, Unit]
  val compose: URLayer[Proxy, Redshift] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new Redshift {
          val api: RedshiftAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : Redshift = this
          def deleteHsmConfiguration(
              request: DeleteHsmConfigurationRequest
          ): IO[AwsError, Unit] = proxy(DeleteHsmConfiguration, request)
          def authorizeSnapshotAccess(
              request: AuthorizeSnapshotAccessRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.AuthorizeSnapshotAccessResponse.ReadOnly
          ] = proxy(AuthorizeSnapshotAccess, request)
          def describeTags(request: DescribeTagsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.redshift.model.TaggedResource.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeTags, request))
          def describeTagsPaginated(request: DescribeTagsRequest): IO[
            AwsError,
            zio.aws.redshift.model.DescribeTagsResponse.ReadOnly
          ] = proxy(DescribeTagsPaginated, request)
          def modifyClusterSubnetGroup(
              request: ModifyClusterSubnetGroupRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.ModifyClusterSubnetGroupResponse.ReadOnly
          ] = proxy(ModifyClusterSubnetGroup, request)
          def resetClusterParameterGroup(
              request: ResetClusterParameterGroupRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.ResetClusterParameterGroupResponse.ReadOnly
          ] = proxy(ResetClusterParameterGroup, request)
          def deleteClusterParameterGroup(
              request: DeleteClusterParameterGroupRequest
          ): IO[AwsError, Unit] = proxy(DeleteClusterParameterGroup, request)
          def resumeCluster(request: ResumeClusterRequest): IO[
            AwsError,
            zio.aws.redshift.model.ResumeClusterResponse.ReadOnly
          ] = proxy(ResumeCluster, request)
          def describeClusters(
              request: DescribeClustersRequest
          ): ZStream[Any, AwsError, zio.aws.redshift.model.Cluster.ReadOnly] =
            rts.unsafeRun(proxy(DescribeClusters, request))
          def describeClustersPaginated(request: DescribeClustersRequest): IO[
            AwsError,
            zio.aws.redshift.model.DescribeClustersResponse.ReadOnly
          ] = proxy(DescribeClustersPaginated, request)
          def modifyUsageLimit(request: ModifyUsageLimitRequest): IO[
            AwsError,
            zio.aws.redshift.model.ModifyUsageLimitResponse.ReadOnly
          ] = proxy(ModifyUsageLimit, request)
          def describeClusterDbRevisions(
              request: DescribeClusterDbRevisionsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.redshift.model.ClusterDbRevision.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeClusterDbRevisions, request))
          def describeClusterDbRevisionsPaginated(
              request: DescribeClusterDbRevisionsRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.DescribeClusterDbRevisionsResponse.ReadOnly
          ] = proxy(DescribeClusterDbRevisionsPaginated, request)
          def acceptReservedNodeExchange(
              request: AcceptReservedNodeExchangeRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.AcceptReservedNodeExchangeResponse.ReadOnly
          ] = proxy(AcceptReservedNodeExchange, request)
          def modifyScheduledAction(request: ModifyScheduledActionRequest): IO[
            AwsError,
            zio.aws.redshift.model.ModifyScheduledActionResponse.ReadOnly
          ] = proxy(ModifyScheduledAction, request)
          def getReservedNodeExchangeConfigurationOptions(
              request: GetReservedNodeExchangeConfigurationOptionsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.redshift.model.ReservedNodeConfigurationOption.ReadOnly
          ] = rts.unsafeRun(
            proxy(GetReservedNodeExchangeConfigurationOptions, request)
          )
          def getReservedNodeExchangeConfigurationOptionsPaginated(
              request: GetReservedNodeExchangeConfigurationOptionsRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.GetReservedNodeExchangeConfigurationOptionsResponse.ReadOnly
          ] =
            proxy(GetReservedNodeExchangeConfigurationOptionsPaginated, request)
          def describeDefaultClusterParameters(
              request: DescribeDefaultClusterParametersRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.DescribeDefaultClusterParametersResponse.ReadOnly
          ] = proxy(DescribeDefaultClusterParameters, request)
          def modifyEndpointAccess(request: ModifyEndpointAccessRequest): IO[
            AwsError,
            zio.aws.redshift.model.ModifyEndpointAccessResponse.ReadOnly
          ] = proxy(ModifyEndpointAccess, request)
          def createClusterSecurityGroup(
              request: CreateClusterSecurityGroupRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.CreateClusterSecurityGroupResponse.ReadOnly
          ] = proxy(CreateClusterSecurityGroup, request)
          def batchDeleteClusterSnapshots(
              request: BatchDeleteClusterSnapshotsRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.BatchDeleteClusterSnapshotsResponse.ReadOnly
          ] = proxy(BatchDeleteClusterSnapshots, request)
          def createAuthenticationProfile(
              request: CreateAuthenticationProfileRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.CreateAuthenticationProfileResponse.ReadOnly
          ] = proxy(CreateAuthenticationProfile, request)
          def deleteHsmClientCertificate(
              request: DeleteHsmClientCertificateRequest
          ): IO[AwsError, Unit] = proxy(DeleteHsmClientCertificate, request)
          def describeClusterParameterGroups(
              request: DescribeClusterParameterGroupsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.redshift.model.ClusterParameterGroup.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeClusterParameterGroups, request))
          def describeClusterParameterGroupsPaginated(
              request: DescribeClusterParameterGroupsRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.DescribeClusterParameterGroupsResponse.ReadOnly
          ] = proxy(DescribeClusterParameterGroupsPaginated, request)
          def describeReservedNodes(
              request: DescribeReservedNodesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.redshift.model.ReservedNode.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeReservedNodes, request))
          def describeReservedNodesPaginated(
              request: DescribeReservedNodesRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.DescribeReservedNodesResponse.ReadOnly
          ] = proxy(DescribeReservedNodesPaginated, request)
          def disableSnapshotCopy(request: DisableSnapshotCopyRequest): IO[
            AwsError,
            zio.aws.redshift.model.DisableSnapshotCopyResponse.ReadOnly
          ] = proxy(DisableSnapshotCopy, request)
          def enableSnapshotCopy(request: EnableSnapshotCopyRequest): IO[
            AwsError,
            zio.aws.redshift.model.EnableSnapshotCopyResponse.ReadOnly
          ] = proxy(EnableSnapshotCopy, request)
          def describeClusterVersions(
              request: DescribeClusterVersionsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.redshift.model.ClusterVersion.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeClusterVersions, request))
          def describeClusterVersionsPaginated(
              request: DescribeClusterVersionsRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.DescribeClusterVersionsResponse.ReadOnly
          ] = proxy(DescribeClusterVersionsPaginated, request)
          def modifyClusterSnapshotSchedule(
              request: ModifyClusterSnapshotScheduleRequest
          ): IO[AwsError, Unit] = proxy(ModifyClusterSnapshotSchedule, request)
          def deleteSnapshotCopyGrant(
              request: DeleteSnapshotCopyGrantRequest
          ): IO[AwsError, Unit] = proxy(DeleteSnapshotCopyGrant, request)
          def modifyAquaConfiguration(
              request: ModifyAquaConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.ModifyAquaConfigurationResponse.ReadOnly
          ] = proxy(ModifyAquaConfiguration, request)
          def describeClusterTracks(
              request: DescribeClusterTracksRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.redshift.model.MaintenanceTrack.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeClusterTracks, request))
          def describeClusterTracksPaginated(
              request: DescribeClusterTracksRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.DescribeClusterTracksResponse.ReadOnly
          ] = proxy(DescribeClusterTracksPaginated, request)
          def createHsmConfiguration(
              request: CreateHsmConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.CreateHsmConfigurationResponse.ReadOnly
          ] = proxy(CreateHsmConfiguration, request)
          def describeDataSharesForConsumer(
              request: DescribeDataSharesForConsumerRequest
          ): ZStream[Any, AwsError, zio.aws.redshift.model.DataShare.ReadOnly] =
            rts.unsafeRun(proxy(DescribeDataSharesForConsumer, request))
          def describeDataSharesForConsumerPaginated(
              request: DescribeDataSharesForConsumerRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.DescribeDataSharesForConsumerResponse.ReadOnly
          ] = proxy(DescribeDataSharesForConsumerPaginated, request)
          def deleteEventSubscription(
              request: DeleteEventSubscriptionRequest
          ): IO[AwsError, Unit] = proxy(DeleteEventSubscription, request)
          def modifyClusterSnapshot(request: ModifyClusterSnapshotRequest): IO[
            AwsError,
            zio.aws.redshift.model.ModifyClusterSnapshotResponse.ReadOnly
          ] = proxy(ModifyClusterSnapshot, request)
          def restoreTableFromClusterSnapshot(
              request: RestoreTableFromClusterSnapshotRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.RestoreTableFromClusterSnapshotResponse.ReadOnly
          ] = proxy(RestoreTableFromClusterSnapshot, request)
          def describeUsageLimits(request: DescribeUsageLimitsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.redshift.model.UsageLimit.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeUsageLimits, request))
          def describeUsageLimitsPaginated(
              request: DescribeUsageLimitsRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.DescribeUsageLimitsResponse.ReadOnly
          ] = proxy(DescribeUsageLimitsPaginated, request)
          def describeResize(request: DescribeResizeRequest): IO[
            AwsError,
            zio.aws.redshift.model.DescribeResizeResponse.ReadOnly
          ] = proxy(DescribeResize, request)
          def deleteSnapshotSchedule(
              request: DeleteSnapshotScheduleRequest
          ): IO[AwsError, Unit] = proxy(DeleteSnapshotSchedule, request)
          def createCluster(request: CreateClusterRequest): IO[
            AwsError,
            zio.aws.redshift.model.CreateClusterResponse.ReadOnly
          ] = proxy(CreateCluster, request)
          def associateDataShareConsumer(
              request: AssociateDataShareConsumerRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.AssociateDataShareConsumerResponse.ReadOnly
          ] = proxy(AssociateDataShareConsumer, request)
          def deleteClusterSnapshot(request: DeleteClusterSnapshotRequest): IO[
            AwsError,
            zio.aws.redshift.model.DeleteClusterSnapshotResponse.ReadOnly
          ] = proxy(DeleteClusterSnapshot, request)
          def deleteCluster(request: DeleteClusterRequest): IO[
            AwsError,
            zio.aws.redshift.model.DeleteClusterResponse.ReadOnly
          ] = proxy(DeleteCluster, request)
          def deleteUsageLimit(
              request: DeleteUsageLimitRequest
          ): IO[AwsError, Unit] = proxy(DeleteUsageLimit, request)
          def cancelResize(request: CancelResizeRequest): IO[
            AwsError,
            zio.aws.redshift.model.CancelResizeResponse.ReadOnly
          ] = proxy(CancelResize, request)
          def pauseCluster(request: PauseClusterRequest): IO[
            AwsError,
            zio.aws.redshift.model.PauseClusterResponse.ReadOnly
          ] = proxy(PauseCluster, request)
          def deleteEndpointAccess(request: DeleteEndpointAccessRequest): IO[
            AwsError,
            zio.aws.redshift.model.DeleteEndpointAccessResponse.ReadOnly
          ] = proxy(DeleteEndpointAccess, request)
          def resizeCluster(request: ResizeClusterRequest): IO[
            AwsError,
            zio.aws.redshift.model.ResizeClusterResponse.ReadOnly
          ] = proxy(ResizeCluster, request)
          def describeClusterSecurityGroups(
              request: DescribeClusterSecurityGroupsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.redshift.model.ClusterSecurityGroup.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeClusterSecurityGroups, request))
          def describeClusterSecurityGroupsPaginated(
              request: DescribeClusterSecurityGroupsRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.DescribeClusterSecurityGroupsResponse.ReadOnly
          ] = proxy(DescribeClusterSecurityGroupsPaginated, request)
          def createSnapshotCopyGrant(
              request: CreateSnapshotCopyGrantRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.CreateSnapshotCopyGrantResponse.ReadOnly
          ] = proxy(CreateSnapshotCopyGrant, request)
          def describeHsmConfigurations(
              request: DescribeHsmConfigurationsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.redshift.model.HsmConfiguration.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeHsmConfigurations, request))
          def describeHsmConfigurationsPaginated(
              request: DescribeHsmConfigurationsRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.DescribeHsmConfigurationsResponse.ReadOnly
          ] = proxy(DescribeHsmConfigurationsPaginated, request)
          def describeClusterParameters(
              request: DescribeClusterParametersRequest
          ): ZStream[Any, AwsError, zio.aws.redshift.model.Parameter.ReadOnly] =
            rts.unsafeRun(proxy(DescribeClusterParameters, request))
          def describeClusterParametersPaginated(
              request: DescribeClusterParametersRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.DescribeClusterParametersResponse.ReadOnly
          ] = proxy(DescribeClusterParametersPaginated, request)
          def createEndpointAccess(request: CreateEndpointAccessRequest): IO[
            AwsError,
            zio.aws.redshift.model.CreateEndpointAccessResponse.ReadOnly
          ] = proxy(CreateEndpointAccess, request)
          def addPartner(
              request: AddPartnerRequest
          ): IO[AwsError, zio.aws.redshift.model.AddPartnerResponse.ReadOnly] =
            proxy(AddPartner, request)
          def describeOrderableClusterOptions(
              request: DescribeOrderableClusterOptionsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.redshift.model.OrderableClusterOption.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeOrderableClusterOptions, request))
          def describeOrderableClusterOptionsPaginated(
              request: DescribeOrderableClusterOptionsRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.DescribeOrderableClusterOptionsResponse.ReadOnly
          ] = proxy(DescribeOrderableClusterOptionsPaginated, request)
          def modifyEventSubscription(
              request: ModifyEventSubscriptionRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.ModifyEventSubscriptionResponse.ReadOnly
          ] = proxy(ModifyEventSubscription, request)
          def describeLoggingStatus(request: DescribeLoggingStatusRequest): IO[
            AwsError,
            zio.aws.redshift.model.DescribeLoggingStatusResponse.ReadOnly
          ] = proxy(DescribeLoggingStatus, request)
          def createHsmClientCertificate(
              request: CreateHsmClientCertificateRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.CreateHsmClientCertificateResponse.ReadOnly
          ] = proxy(CreateHsmClientCertificate, request)
          def deletePartner(request: DeletePartnerRequest): IO[
            AwsError,
            zio.aws.redshift.model.DeletePartnerResponse.ReadOnly
          ] = proxy(DeletePartner, request)
          def describeNodeConfigurationOptions(
              request: DescribeNodeConfigurationOptionsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.redshift.model.NodeConfigurationOption.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeNodeConfigurationOptions, request))
          def describeNodeConfigurationOptionsPaginated(
              request: DescribeNodeConfigurationOptionsRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.DescribeNodeConfigurationOptionsResponse.ReadOnly
          ] = proxy(DescribeNodeConfigurationOptionsPaginated, request)
          def describeTableRestoreStatus(
              request: DescribeTableRestoreStatusRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.redshift.model.TableRestoreStatus.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeTableRestoreStatus, request))
          def describeTableRestoreStatusPaginated(
              request: DescribeTableRestoreStatusRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.DescribeTableRestoreStatusResponse.ReadOnly
          ] = proxy(DescribeTableRestoreStatusPaginated, request)
          def rebootCluster(request: RebootClusterRequest): IO[
            AwsError,
            zio.aws.redshift.model.RebootClusterResponse.ReadOnly
          ] = proxy(RebootCluster, request)
          def enableLogging(request: EnableLoggingRequest): IO[
            AwsError,
            zio.aws.redshift.model.EnableLoggingResponse.ReadOnly
          ] = proxy(EnableLogging, request)
          def revokeEndpointAccess(request: RevokeEndpointAccessRequest): IO[
            AwsError,
            zio.aws.redshift.model.RevokeEndpointAccessResponse.ReadOnly
          ] = proxy(RevokeEndpointAccess, request)
          def describeAuthenticationProfiles(
              request: DescribeAuthenticationProfilesRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.DescribeAuthenticationProfilesResponse.ReadOnly
          ] = proxy(DescribeAuthenticationProfiles, request)
          def createScheduledAction(request: CreateScheduledActionRequest): IO[
            AwsError,
            zio.aws.redshift.model.CreateScheduledActionResponse.ReadOnly
          ] = proxy(CreateScheduledAction, request)
          def deleteClusterSecurityGroup(
              request: DeleteClusterSecurityGroupRequest
          ): IO[AwsError, Unit] = proxy(DeleteClusterSecurityGroup, request)
          def describePartners(request: DescribePartnersRequest): IO[
            AwsError,
            zio.aws.redshift.model.DescribePartnersResponse.ReadOnly
          ] = proxy(DescribePartners, request)
          def describeHsmClientCertificates(
              request: DescribeHsmClientCertificatesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.redshift.model.HsmClientCertificate.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeHsmClientCertificates, request))
          def describeHsmClientCertificatesPaginated(
              request: DescribeHsmClientCertificatesRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.DescribeHsmClientCertificatesResponse.ReadOnly
          ] = proxy(DescribeHsmClientCertificatesPaginated, request)
          def describeEventCategories(
              request: DescribeEventCategoriesRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.DescribeEventCategoriesResponse.ReadOnly
          ] = proxy(DescribeEventCategories, request)
          def modifyClusterDbRevision(
              request: ModifyClusterDbRevisionRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.ModifyClusterDbRevisionResponse.ReadOnly
          ] = proxy(ModifyClusterDbRevision, request)
          def createSnapshotSchedule(
              request: CreateSnapshotScheduleRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.CreateSnapshotScheduleResponse.ReadOnly
          ] = proxy(CreateSnapshotSchedule, request)
          def describeDataShares(
              request: DescribeDataSharesRequest
          ): ZStream[Any, AwsError, zio.aws.redshift.model.DataShare.ReadOnly] =
            rts.unsafeRun(proxy(DescribeDataShares, request))
          def describeDataSharesPaginated(
              request: DescribeDataSharesRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.DescribeDataSharesResponse.ReadOnly
          ] = proxy(DescribeDataSharesPaginated, request)
          def describeClusterSnapshots(
              request: DescribeClusterSnapshotsRequest
          ): ZStream[Any, AwsError, zio.aws.redshift.model.Snapshot.ReadOnly] =
            rts.unsafeRun(proxy(DescribeClusterSnapshots, request))
          def describeClusterSnapshotsPaginated(
              request: DescribeClusterSnapshotsRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.DescribeClusterSnapshotsResponse.ReadOnly
          ] = proxy(DescribeClusterSnapshotsPaginated, request)
          def getReservedNodeExchangeOfferings(
              request: GetReservedNodeExchangeOfferingsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.redshift.model.ReservedNodeOffering.ReadOnly
          ] = rts.unsafeRun(proxy(GetReservedNodeExchangeOfferings, request))
          def getReservedNodeExchangeOfferingsPaginated(
              request: GetReservedNodeExchangeOfferingsRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.GetReservedNodeExchangeOfferingsResponse.ReadOnly
          ] = proxy(GetReservedNodeExchangeOfferingsPaginated, request)
          def describeStorage(): IO[
            AwsError,
            zio.aws.redshift.model.DescribeStorageResponse.ReadOnly
          ] = proxy(DescribeStorage)
          def modifyCluster(request: ModifyClusterRequest): IO[
            AwsError,
            zio.aws.redshift.model.ModifyClusterResponse.ReadOnly
          ] = proxy(ModifyCluster, request)
          def authorizeDataShare(request: AuthorizeDataShareRequest): IO[
            AwsError,
            zio.aws.redshift.model.AuthorizeDataShareResponse.ReadOnly
          ] = proxy(AuthorizeDataShare, request)
          def describeReservedNodeExchangeStatus(
              request: DescribeReservedNodeExchangeStatusRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.redshift.model.ReservedNodeExchangeStatus.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeReservedNodeExchangeStatus, request))
          def describeReservedNodeExchangeStatusPaginated(
              request: DescribeReservedNodeExchangeStatusRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.DescribeReservedNodeExchangeStatusResponse.ReadOnly
          ] = proxy(DescribeReservedNodeExchangeStatusPaginated, request)
          def modifyClusterParameterGroup(
              request: ModifyClusterParameterGroupRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.ModifyClusterParameterGroupResponse.ReadOnly
          ] = proxy(ModifyClusterParameterGroup, request)
          def revokeSnapshotAccess(request: RevokeSnapshotAccessRequest): IO[
            AwsError,
            zio.aws.redshift.model.RevokeSnapshotAccessResponse.ReadOnly
          ] = proxy(RevokeSnapshotAccess, request)
          def createEventSubscription(
              request: CreateEventSubscriptionRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.CreateEventSubscriptionResponse.ReadOnly
          ] = proxy(CreateEventSubscription, request)
          def modifyClusterMaintenance(
              request: ModifyClusterMaintenanceRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.ModifyClusterMaintenanceResponse.ReadOnly
          ] = proxy(ModifyClusterMaintenance, request)
          def createUsageLimit(request: CreateUsageLimitRequest): IO[
            AwsError,
            zio.aws.redshift.model.CreateUsageLimitResponse.ReadOnly
          ] = proxy(CreateUsageLimit, request)
          def modifySnapshotCopyRetentionPeriod(
              request: ModifySnapshotCopyRetentionPeriodRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.ModifySnapshotCopyRetentionPeriodResponse.ReadOnly
          ] = proxy(ModifySnapshotCopyRetentionPeriod, request)
          def deauthorizeDataShare(request: DeauthorizeDataShareRequest): IO[
            AwsError,
            zio.aws.redshift.model.DeauthorizeDataShareResponse.ReadOnly
          ] = proxy(DeauthorizeDataShare, request)
          def rotateEncryptionKey(request: RotateEncryptionKeyRequest): IO[
            AwsError,
            zio.aws.redshift.model.RotateEncryptionKeyResponse.ReadOnly
          ] = proxy(RotateEncryptionKey, request)
          def describeEndpointAuthorization(
              request: DescribeEndpointAuthorizationRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.redshift.model.EndpointAuthorization.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeEndpointAuthorization, request))
          def describeEndpointAuthorizationPaginated(
              request: DescribeEndpointAuthorizationRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.DescribeEndpointAuthorizationResponse.ReadOnly
          ] = proxy(DescribeEndpointAuthorizationPaginated, request)
          def describeScheduledActions(
              request: DescribeScheduledActionsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.redshift.model.ScheduledAction.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeScheduledActions, request))
          def describeScheduledActionsPaginated(
              request: DescribeScheduledActionsRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.DescribeScheduledActionsResponse.ReadOnly
          ] = proxy(DescribeScheduledActionsPaginated, request)
          def modifyClusterIamRoles(request: ModifyClusterIamRolesRequest): IO[
            AwsError,
            zio.aws.redshift.model.ModifyClusterIamRolesResponse.ReadOnly
          ] = proxy(ModifyClusterIamRoles, request)
          def deleteScheduledAction(
              request: DeleteScheduledActionRequest
          ): IO[AwsError, Unit] = proxy(DeleteScheduledAction, request)
          def getClusterCredentials(request: GetClusterCredentialsRequest): IO[
            AwsError,
            zio.aws.redshift.model.GetClusterCredentialsResponse.ReadOnly
          ] = proxy(GetClusterCredentials, request)
          def rejectDataShare(request: RejectDataShareRequest): IO[
            AwsError,
            zio.aws.redshift.model.RejectDataShareResponse.ReadOnly
          ] = proxy(RejectDataShare, request)
          def describeEventSubscriptions(
              request: DescribeEventSubscriptionsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.redshift.model.EventSubscription.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeEventSubscriptions, request))
          def describeEventSubscriptionsPaginated(
              request: DescribeEventSubscriptionsRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.DescribeEventSubscriptionsResponse.ReadOnly
          ] = proxy(DescribeEventSubscriptionsPaginated, request)
          def deleteAuthenticationProfile(
              request: DeleteAuthenticationProfileRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.DeleteAuthenticationProfileResponse.ReadOnly
          ] = proxy(DeleteAuthenticationProfile, request)
          def createClusterParameterGroup(
              request: CreateClusterParameterGroupRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.CreateClusterParameterGroupResponse.ReadOnly
          ] = proxy(CreateClusterParameterGroup, request)
          def createClusterSnapshot(request: CreateClusterSnapshotRequest): IO[
            AwsError,
            zio.aws.redshift.model.CreateClusterSnapshotResponse.ReadOnly
          ] = proxy(CreateClusterSnapshot, request)
          def describeSnapshotSchedules(
              request: DescribeSnapshotSchedulesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.redshift.model.SnapshotSchedule.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeSnapshotSchedules, request))
          def describeSnapshotSchedulesPaginated(
              request: DescribeSnapshotSchedulesRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.DescribeSnapshotSchedulesResponse.ReadOnly
          ] = proxy(DescribeSnapshotSchedulesPaginated, request)
          def describeClusterSubnetGroups(
              request: DescribeClusterSubnetGroupsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.redshift.model.ClusterSubnetGroup.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeClusterSubnetGroups, request))
          def describeClusterSubnetGroupsPaginated(
              request: DescribeClusterSubnetGroupsRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.DescribeClusterSubnetGroupsResponse.ReadOnly
          ] = proxy(DescribeClusterSubnetGroupsPaginated, request)
          def createClusterSubnetGroup(
              request: CreateClusterSubnetGroupRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.CreateClusterSubnetGroupResponse.ReadOnly
          ] = proxy(CreateClusterSubnetGroup, request)
          def modifyAuthenticationProfile(
              request: ModifyAuthenticationProfileRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.ModifyAuthenticationProfileResponse.ReadOnly
          ] = proxy(ModifyAuthenticationProfile, request)
          def describeDataSharesForProducer(
              request: DescribeDataSharesForProducerRequest
          ): ZStream[Any, AwsError, zio.aws.redshift.model.DataShare.ReadOnly] =
            rts.unsafeRun(proxy(DescribeDataSharesForProducer, request))
          def describeDataSharesForProducerPaginated(
              request: DescribeDataSharesForProducerRequest
          ): IO[AwsError, ReadOnly] =
            proxy(DescribeDataSharesForProducerPaginated, request)
          def describeReservedNodeOfferings(
              request: DescribeReservedNodeOfferingsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.redshift.model.ReservedNodeOffering.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeReservedNodeOfferings, request))
          def describeReservedNodeOfferingsPaginated(
              request: DescribeReservedNodeOfferingsRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.DescribeReservedNodeOfferingsResponse.ReadOnly
          ] = proxy(DescribeReservedNodeOfferingsPaginated, request)
          def modifySnapshotSchedule(
              request: ModifySnapshotScheduleRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.ModifySnapshotScheduleResponse.ReadOnly
          ] = proxy(ModifySnapshotSchedule, request)
          def deleteTags(request: DeleteTagsRequest): IO[AwsError, Unit] =
            proxy(DeleteTags, request)
          def purchaseReservedNodeOffering(
              request: PurchaseReservedNodeOfferingRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.PurchaseReservedNodeOfferingResponse.ReadOnly
          ] = proxy(PurchaseReservedNodeOffering, request)
          def describeAccountAttributes(
              request: DescribeAccountAttributesRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.DescribeAccountAttributesResponse.ReadOnly
          ] = proxy(DescribeAccountAttributes, request)
          def batchModifyClusterSnapshots(
              request: BatchModifyClusterSnapshotsRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.BatchModifyClusterSnapshotsResponse.ReadOnly
          ] = proxy(BatchModifyClusterSnapshots, request)
          def deleteClusterSubnetGroup(
              request: DeleteClusterSubnetGroupRequest
          ): IO[AwsError, Unit] = proxy(DeleteClusterSubnetGroup, request)
          def revokeClusterSecurityGroupIngress(
              request: RevokeClusterSecurityGroupIngressRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.RevokeClusterSecurityGroupIngressResponse.ReadOnly
          ] = proxy(RevokeClusterSecurityGroupIngress, request)
          def authorizeClusterSecurityGroupIngress(
              request: AuthorizeClusterSecurityGroupIngressRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.AuthorizeClusterSecurityGroupIngressResponse.ReadOnly
          ] = proxy(AuthorizeClusterSecurityGroupIngress, request)
          def updatePartnerStatus(request: UpdatePartnerStatusRequest): IO[
            AwsError,
            zio.aws.redshift.model.UpdatePartnerStatusResponse.ReadOnly
          ] = proxy(UpdatePartnerStatus, request)
          def copyClusterSnapshot(request: CopyClusterSnapshotRequest): IO[
            AwsError,
            zio.aws.redshift.model.CopyClusterSnapshotResponse.ReadOnly
          ] = proxy(CopyClusterSnapshot, request)
          def describeSnapshotCopyGrants(
              request: DescribeSnapshotCopyGrantsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.redshift.model.SnapshotCopyGrant.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeSnapshotCopyGrants, request))
          def describeSnapshotCopyGrantsPaginated(
              request: DescribeSnapshotCopyGrantsRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.DescribeSnapshotCopyGrantsResponse.ReadOnly
          ] = proxy(DescribeSnapshotCopyGrantsPaginated, request)
          def authorizeEndpointAccess(
              request: AuthorizeEndpointAccessRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.AuthorizeEndpointAccessResponse.ReadOnly
          ] = proxy(AuthorizeEndpointAccess, request)
          def restoreFromClusterSnapshot(
              request: RestoreFromClusterSnapshotRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.RestoreFromClusterSnapshotResponse.ReadOnly
          ] = proxy(RestoreFromClusterSnapshot, request)
          def disableLogging(request: DisableLoggingRequest): IO[
            AwsError,
            zio.aws.redshift.model.DisableLoggingResponse.ReadOnly
          ] = proxy(DisableLogging, request)
          def disassociateDataShareConsumer(
              request: DisassociateDataShareConsumerRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.DisassociateDataShareConsumerResponse.ReadOnly
          ] = proxy(DisassociateDataShareConsumer, request)
          def describeEvents(
              request: DescribeEventsRequest
          ): ZStream[Any, AwsError, zio.aws.redshift.model.Event.ReadOnly] =
            rts.unsafeRun(proxy(DescribeEvents, request))
          def describeEventsPaginated(request: DescribeEventsRequest): IO[
            AwsError,
            zio.aws.redshift.model.DescribeEventsResponse.ReadOnly
          ] = proxy(DescribeEventsPaginated, request)
          def describeEndpointAccess(
              request: DescribeEndpointAccessRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.redshift.model.EndpointAccess.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeEndpointAccess, request))
          def describeEndpointAccessPaginated(
              request: DescribeEndpointAccessRequest
          ): IO[
            AwsError,
            zio.aws.redshift.model.DescribeEndpointAccessResponse.ReadOnly
          ] = proxy(DescribeEndpointAccessPaginated, request)
          def createTags(request: CreateTagsRequest): IO[AwsError, Unit] =
            proxy(CreateTags, request)
        }
      }
    }
  }
}
