package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeScheduledActionsResponse(
    marker: Optional[String] = Optional.Absent,
    scheduledActions: Optional[
      Iterable[zio.aws.redshift.model.ScheduledAction]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeScheduledActionsResponse = {
    import DescribeScheduledActionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeScheduledActionsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        scheduledActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scheduledActions)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeScheduledActionsResponse.ReadOnly =
    zio.aws.redshift.model.DescribeScheduledActionsResponse
      .wrap(buildAwsValue())
}
object DescribeScheduledActionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeScheduledActionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeScheduledActionsResponse =
      zio.aws.redshift.model.DescribeScheduledActionsResponse(
        marker.map(value => value),
        scheduledActions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def scheduledActions
        : Optional[List[zio.aws.redshift.model.ScheduledAction.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getScheduledActions: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.ScheduledAction.ReadOnly
    ]] = AwsError.unwrapOptionField("scheduledActions", scheduledActions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeScheduledActionsResponse
  ) extends zio.aws.redshift.model.DescribeScheduledActionsResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val scheduledActions
        : Optional[List[zio.aws.redshift.model.ScheduledAction.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduledActions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.ScheduledAction.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeScheduledActionsResponse
  ): zio.aws.redshift.model.DescribeScheduledActionsResponse.ReadOnly =
    new Wrapper(impl)
}
