package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyEventSubscriptionResponse(
    eventSubscription: Optional[zio.aws.redshift.model.EventSubscription] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ModifyEventSubscriptionResponse = {
    import ModifyEventSubscriptionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ModifyEventSubscriptionResponse
      .builder()
      .optionallyWith(eventSubscription.map(value => value.buildAwsValue()))(
        _.eventSubscription
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.ModifyEventSubscriptionResponse.ReadOnly =
    zio.aws.redshift.model.ModifyEventSubscriptionResponse.wrap(buildAwsValue())
}
object ModifyEventSubscriptionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ModifyEventSubscriptionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ModifyEventSubscriptionResponse =
      zio.aws.redshift.model.ModifyEventSubscriptionResponse(
        eventSubscription.map(value => value.asEditable)
      )
    def eventSubscription
        : Optional[zio.aws.redshift.model.EventSubscription.ReadOnly]
    def getEventSubscription: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.EventSubscription.ReadOnly
    ] = AwsError.unwrapOptionField("eventSubscription", eventSubscription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ModifyEventSubscriptionResponse
  ) extends zio.aws.redshift.model.ModifyEventSubscriptionResponse.ReadOnly {
    override val eventSubscription
        : Optional[zio.aws.redshift.model.EventSubscription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventSubscription())
        .map(value => zio.aws.redshift.model.EventSubscription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ModifyEventSubscriptionResponse
  ): zio.aws.redshift.model.ModifyEventSubscriptionResponse.ReadOnly =
    new Wrapper(impl)
}
