package zio.aws.redshift.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.TStamp
import scala.jdk.CollectionConverters._
final case class EventSubscription(
    customerAwsId: Optional[String] = Optional.Absent,
    custSubscriptionId: Optional[String] = Optional.Absent,
    snsTopicArn: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    subscriptionCreationTime: Optional[TStamp] = Optional.Absent,
    sourceType: Optional[String] = Optional.Absent,
    sourceIdsList: Optional[Iterable[String]] = Optional.Absent,
    eventCategoriesList: Optional[Iterable[String]] = Optional.Absent,
    severity: Optional[String] = Optional.Absent,
    enabled: Optional[Boolean] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.redshift.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.EventSubscription = {
    import EventSubscription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.EventSubscription
      .builder()
      .optionallyWith(customerAwsId.map(value => value: java.lang.String))(
        _.customerAwsId
      )
      .optionallyWith(custSubscriptionId.map(value => value: java.lang.String))(
        _.custSubscriptionId
      )
      .optionallyWith(snsTopicArn.map(value => value: java.lang.String))(
        _.snsTopicArn
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        subscriptionCreationTime.map(value => TStamp.unwrap(value): Instant)
      )(_.subscriptionCreationTime)
      .optionallyWith(sourceType.map(value => value: java.lang.String))(
        _.sourceType
      )
      .optionallyWith(
        sourceIdsList.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.sourceIdsList)
      .optionallyWith(
        eventCategoriesList.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.eventCategoriesList)
      .optionallyWith(severity.map(value => value: java.lang.String))(
        _.severity
      )
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.EventSubscription.ReadOnly =
    zio.aws.redshift.model.EventSubscription.wrap(buildAwsValue())
}
object EventSubscription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.EventSubscription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.EventSubscription =
      zio.aws.redshift.model.EventSubscription(
        customerAwsId.map(value => value),
        custSubscriptionId.map(value => value),
        snsTopicArn.map(value => value),
        status.map(value => value),
        subscriptionCreationTime.map(value => value),
        sourceType.map(value => value),
        sourceIdsList.map(value => value),
        eventCategoriesList.map(value => value),
        severity.map(value => value),
        enabled.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def customerAwsId: Optional[String]
    def custSubscriptionId: Optional[String]
    def snsTopicArn: Optional[String]
    def status: Optional[String]
    def subscriptionCreationTime: Optional[TStamp]
    def sourceType: Optional[String]
    def sourceIdsList: Optional[List[String]]
    def eventCategoriesList: Optional[List[String]]
    def severity: Optional[String]
    def enabled: Optional[Boolean]
    def tags: Optional[List[zio.aws.redshift.model.Tag.ReadOnly]]
    def getCustomerAwsId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("customerAwsId", customerAwsId)
    def getCustSubscriptionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("custSubscriptionId", custSubscriptionId)
    def getSnsTopicArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArn)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getSubscriptionCreationTime: ZIO[Any, AwsError, TStamp] = AwsError
      .unwrapOptionField("subscriptionCreationTime", subscriptionCreationTime)
    def getSourceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getSourceIdsList: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("sourceIdsList", sourceIdsList)
    def getEventCategoriesList: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("eventCategoriesList", eventCategoriesList)
    def getSeverity: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("severity", severity)
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getTags: ZIO[Any, AwsError, List[zio.aws.redshift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.EventSubscription
  ) extends zio.aws.redshift.model.EventSubscription.ReadOnly {
    override val customerAwsId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.customerAwsId())
      .map(value => value: String)
    override val custSubscriptionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.custSubscriptionId())
      .map(value => value: String)
    override val snsTopicArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snsTopicArn())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val subscriptionCreationTime: Optional[TStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subscriptionCreationTime())
        .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val sourceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceType())
      .map(value => value: String)
    override val sourceIdsList: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceIdsList())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val eventCategoriesList: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventCategoriesList())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val severity: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.severity())
      .map(value => value: String)
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
    override val tags: Optional[List[zio.aws.redshift.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.EventSubscription
  ): zio.aws.redshift.model.EventSubscription.ReadOnly = new Wrapper(impl)
}
