package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeClusterParameterGroupsResponse(
    marker: Optional[String] = Optional.Absent,
    parameterGroups: Optional[
      Iterable[zio.aws.redshift.model.ClusterParameterGroup]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsResponse = {
    import DescribeClusterParameterGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        parameterGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameterGroups)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeClusterParameterGroupsResponse.ReadOnly =
    zio.aws.redshift.model.DescribeClusterParameterGroupsResponse
      .wrap(buildAwsValue())
}
object DescribeClusterParameterGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.DescribeClusterParameterGroupsResponse =
      zio.aws.redshift.model.DescribeClusterParameterGroupsResponse(
        marker.map(value => value),
        parameterGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def parameterGroups
        : Optional[List[zio.aws.redshift.model.ClusterParameterGroup.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getParameterGroups: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.ClusterParameterGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("parameterGroups", parameterGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsResponse
  ) extends zio.aws.redshift.model.DescribeClusterParameterGroupsResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val parameterGroups: Optional[
      List[zio.aws.redshift.model.ClusterParameterGroup.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.parameterGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.ClusterParameterGroup.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsResponse
  ): zio.aws.redshift.model.DescribeClusterParameterGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
