package zio.aws.redshift.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.{
  BooleanOptional,
  IntegerOptional,
  TStamp
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeClusterSnapshotsRequest(
    clusterIdentifier: Optional[String] = Optional.Absent,
    snapshotIdentifier: Optional[String] = Optional.Absent,
    snapshotType: Optional[String] = Optional.Absent,
    startTime: Optional[TStamp] = Optional.Absent,
    endTime: Optional[TStamp] = Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent,
    ownerAccount: Optional[String] = Optional.Absent,
    tagKeys: Optional[Iterable[String]] = Optional.Absent,
    tagValues: Optional[Iterable[String]] = Optional.Absent,
    clusterExists: Optional[BooleanOptional] = Optional.Absent,
    sortingEntities: Optional[
      Iterable[zio.aws.redshift.model.SnapshotSortingEntity]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsRequest = {
    import DescribeClusterSnapshotsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsRequest
      .builder()
      .optionallyWith(clusterIdentifier.map(value => value: java.lang.String))(
        _.clusterIdentifier
      )
      .optionallyWith(snapshotIdentifier.map(value => value: java.lang.String))(
        _.snapshotIdentifier
      )
      .optionallyWith(snapshotType.map(value => value: java.lang.String))(
        _.snapshotType
      )
      .optionallyWith(startTime.map(value => TStamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => TStamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(ownerAccount.map(value => value: java.lang.String))(
        _.ownerAccount
      )
      .optionallyWith(
        tagKeys.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.tagKeys)
      .optionallyWith(
        tagValues.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.tagValues)
      .optionallyWith(clusterExists.map(value => value: java.lang.Boolean))(
        _.clusterExists
      )
      .optionallyWith(
        sortingEntities.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sortingEntities)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeClusterSnapshotsRequest.ReadOnly =
    zio.aws.redshift.model.DescribeClusterSnapshotsRequest.wrap(buildAwsValue())
}
object DescribeClusterSnapshotsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeClusterSnapshotsRequest =
      zio.aws.redshift.model.DescribeClusterSnapshotsRequest(
        clusterIdentifier.map(value => value),
        snapshotIdentifier.map(value => value),
        snapshotType.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value),
        ownerAccount.map(value => value),
        tagKeys.map(value => value),
        tagValues.map(value => value),
        clusterExists.map(value => value),
        sortingEntities.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clusterIdentifier: Optional[String]
    def snapshotIdentifier: Optional[String]
    def snapshotType: Optional[String]
    def startTime: Optional[TStamp]
    def endTime: Optional[TStamp]
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def ownerAccount: Optional[String]
    def tagKeys: Optional[List[String]]
    def tagValues: Optional[List[String]]
    def clusterExists: Optional[BooleanOptional]
    def sortingEntities
        : Optional[List[zio.aws.redshift.model.SnapshotSortingEntity.ReadOnly]]
    def getClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getSnapshotIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotIdentifier", snapshotIdentifier)
    def getSnapshotType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotType", snapshotType)
    def getStartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getOwnerAccount: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerAccount", ownerAccount)
    def getTagKeys: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("tagKeys", tagKeys)
    def getTagValues: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("tagValues", tagValues)
    def getClusterExists: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("clusterExists", clusterExists)
    def getSortingEntities: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.SnapshotSortingEntity.ReadOnly
    ]] = AwsError.unwrapOptionField("sortingEntities", sortingEntities)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsRequest
  ) extends zio.aws.redshift.model.DescribeClusterSnapshotsRequest.ReadOnly {
    override val clusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterIdentifier())
      .map(value => value: String)
    override val snapshotIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotIdentifier())
      .map(value => value: String)
    override val snapshotType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotType())
      .map(value => value: String)
    override val startTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val endTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val ownerAccount: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerAccount())
      .map(value => value: String)
    override val tagKeys: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tagKeys())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val tagValues: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tagValues())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val clusterExists: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterExists())
        .map(value => value: BooleanOptional)
    override val sortingEntities: Optional[
      List[zio.aws.redshift.model.SnapshotSortingEntity.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sortingEntities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.SnapshotSortingEntity.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsRequest
  ): zio.aws.redshift.model.DescribeClusterSnapshotsRequest.ReadOnly =
    new Wrapper(impl)
}
