package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EnableLoggingRequest(
    clusterIdentifier: String,
    bucketName: String,
    s3KeyPrefix: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.EnableLoggingRequest = {
    import EnableLoggingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.EnableLoggingRequest
      .builder()
      .clusterIdentifier(clusterIdentifier: java.lang.String)
      .bucketName(bucketName: java.lang.String)
      .optionallyWith(s3KeyPrefix.map(value => value: java.lang.String))(
        _.s3KeyPrefix
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.EnableLoggingRequest.ReadOnly =
    zio.aws.redshift.model.EnableLoggingRequest.wrap(buildAwsValue())
}
object EnableLoggingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.EnableLoggingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.EnableLoggingRequest =
      zio.aws.redshift.model.EnableLoggingRequest(
        clusterIdentifier,
        bucketName,
        s3KeyPrefix.map(value => value)
      )
    def clusterIdentifier: String
    def bucketName: String
    def s3KeyPrefix: Option[String]
    def getClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(clusterIdentifier)
    def getBucketName: ZIO[Any, Nothing, String] = ZIO.succeed(bucketName)
    def getS3KeyPrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3KeyPrefix", s3KeyPrefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.EnableLoggingRequest
  ) extends zio.aws.redshift.model.EnableLoggingRequest.ReadOnly {
    override val clusterIdentifier: String = impl.clusterIdentifier(): String
    override val bucketName: String = impl.bucketName(): String
    override val s3KeyPrefix: Option[String] =
      scala.Option(impl.s3KeyPrefix()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.EnableLoggingRequest
  ): zio.aws.redshift.model.EnableLoggingRequest.ReadOnly = new Wrapper(impl)
}
